package net.polyv.live.v2.entity.channel.session;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询频道场次信息响应实体
 * @author liyongxuan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道场次信息响应实体")
public class LiveSessionListResponse extends LivePageCommonResponse {
    
    /**
     * 查询的结果列表
     */
    @ApiModelProperty(name = "contents", value = "查询的结果列表", required = false)
    private List<LiveSessionListResponse.SessionInfo> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class SessionInfo {
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 直播场次ID
         */
        @ApiModelProperty(name = "sessionId", value = "直播场次ID", required = false)
        private String sessionId;
        
        /**
         * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
         */
        @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
        private String userId;
        
        /**
         * 直播开始时间，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "startTime", value = "直播开始时间", required = false)
        private Date startTime;
        
        /**
         * 直播结束时间，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "endTime", value = "直播结束时间", required = false)
        private Date endTime;
    }
    
}