package net.polyv.live.v2.entity.channel.operate;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道设置请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道设置请求实体")
public class LiveUpdateChannelRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 直播名称，最大长度100
     */
    @ApiModelProperty(name = "name", value = "直播名称，最大长度100", required = false)
    private String name;
    
    /**
     * 密码，长度6-16位，需同时包含数字与字母
     */
    @ApiModelProperty(name = "password", value = "密码，长度6-16位，需同时包含数字与字母", required = false)
    private String password;
    
    /**
     * 主持人密码，频道场景为研讨会有效，长度6-16位，需同时包含数字与字母
     */
    @ApiModelProperty(name = "seminarHostPassword", value = "主持人密码，频道场景为研讨会有效，长度6-16位，需同时包含数字与字母", required = false)
    private String seminarHostPassword;
    
    /**
     * 参会人密码，频道场景为研讨会有效，长度6-16位，需同时包含数字与字母
     */
    @ApiModelProperty(name = "seminarAttendeePassword", value = "参会人密码，频道场景为研讨会有效，长度6-16位，需同时包含数字与字母", required = false)
    private String seminarAttendeePassword;
    
    /**
     * 主持人，最大长度100
     */
    @ApiModelProperty(name = "publisher", value = "主持人，最大长度100", required = false)
    private String publisher;
    
    /**
     * 直播观看模板 三分屏-横屏：ppt 三分屏-竖屏：portrait_ppt 纯视频-横屏：alone 纯视频-竖屏：portrait_alone 纯视频-极速-横屏：topclass
     * 纯视频-极速-竖屏：portrait_topclass 旧版后台频道（场景为未定义 newScene：undefined）不支持修改 研讨会（seminar）场景不支持修改
     * 场景为三分屏（scene：ppt）可修改值：ppt、portrait_ppt 场景为纯视频（scene：alone）可修改值：alone、portrait_alone
     * 场景为大班课（scene：topclass）可修改值：topclass、portrait_topclass
     */
    @ApiModelProperty(name = "template", value = "直播观看模板 三分屏-横屏：ppt 三分屏-竖屏：portrait_ppt 纯视频-横屏：alone " +
            "纯视频-竖屏：portrait_alone 纯视频-极速-横屏：topclass 纯视频-极速-竖屏：portrait_topclass 旧版后台频道（场景为未定义 " +
            "newScene：undefined）不支持修改 研讨会（seminar）场景不支持修改 场景为三分屏（scene：ppt）可修改值：ppt、portrait_ppt " +
            "场景为纯视频（scene：alone）可修改值：alone、portrait_alone 场景为大班课（scene：topclass）可修改值：topclass、portrait_topclass",
            required = false)
    private String template;
    
    /**
     * 无延时直播开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "pureRtcEnabled", value = "无延时直播开关 Y：开启 N：关闭", required = false)
    private String pureRtcEnabled;
    
    /**
     * 连麦人数，范围：0-16
     */
    @ApiModelProperty(name = "linkMicLimit", value = "连麦人数，范围：0-16", required = false)
    private Integer linkMicLimit;
    
    /**
     * 最大同时在线人数
     */
    @ApiModelProperty(name = "maxViewer", value = "最大同时在线人数", required = false)
    private Integer maxViewer;
    
    /**
     * 直播开始时间，需大于当前时间
     */
    @ApiModelProperty(name = "startTime", value = "直播开始时间，需大于当前时间", required = false)
    private Date startTime;
    
    /**
     * 直播结束时间，需大于直播开始时间
     */
    @ApiModelProperty(name = "endTime", value = "直播结束时间，需大于直播开始时间", required = false)
    private Date endTime;
    
    /**
     * 引导页图片地址，非保利威域名下的图片需先调用[上传图片资源](/live/java/webSetting?id=_2、上传图片资源)上传
     */
    @ApiModelProperty(name = "splashImg", value = "引导页图片地址，非保利威域名下的图片需先调用[上传图片资源](/live/java/webSetting?id=_2、上传图片资源)上传", required = false)
    private String splashImg;
    
}