package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量删除频道多条聊天记录请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量删除频道多条聊天记录请求实体")
public class LiveRemoveChatContentsRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 聊天记录对应的id(多个id使用英文逗号隔开)，该参数获取自【查询频道聊天记录】
     */
    @ApiModelProperty(name = "ids", value = "聊天记录对应的id(多个id使用英文逗号隔开)，该参数获取自【查询频道聊天记录】", required = true)
    @NotNull(message = "属性ids不能为空")
    private String ids;
    
}