package net.polyv.live.v1.service.finance.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import lombok.extern.slf4j.Slf4j;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.finance.ILiveUserBillService;
import net.polyv.live.v2.entity.user.finance.LiveGetBillUseDetailRequest;
import net.polyv.live.v2.entity.user.finance.LiveGetBillUseDetailResponse;

/**
 * 直播用户账单
 * @author: sadboy
 */
@Slf4j
public class LiveUserBillServiceImpl extends LiveBaseService implements ILiveUserBillService {
    
    
    /**
     * 查询用户账单使用详情数据
     * API地址：https://help.polyv.net/#/live/api/v4/user/bill/use_detail_list
     * @param liveGetBillUseDetailRequest 查询用户账单使用详情数据请求实体
     * @return 查询用户账单使用详情数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetBillUseDetailResponse getBillUseDetail(LiveGetBillUseDetailRequest liveGetBillUseDetailRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.USER_BILL_USE_DETAIL_LIST_URL;
        return super.getReturnOne(url, liveGetBillUseDetailRequest, LiveGetBillUseDetailResponse.class);
    }
}
