package net.polyv.live.v1.service.finance;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v2.entity.user.finance.LiveGetBillUseDetailRequest;
import net.polyv.live.v2.entity.user.finance.LiveGetBillUseDetailResponse;

/**
 * 直播用户账单
 * @author: sadboy
 */
public interface ILiveUserBillService {
    
    /**
     * 查询用户账单使用详情数据
     * API地址：https://help.polyv.net/#/live/api/v4/user/bill/use_detail_list
     * @param liveGetBillUseDetailRequest 查询用户账单使用详情数据请求实体
     * @return 查询用户账单使用详情数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetBillUseDetailResponse getBillUseDetail(LiveGetBillUseDetailRequest liveGetBillUseDetailRequest)
            throws IOException, NoSuchAlgorithmException;
    
}
