package net.polyv.live.v1.service.children;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.live.v2.entity.user.children.LiveCreateOrganizationRequest;
import net.polyv.live.v2.entity.user.children.LiveCreateOrganizationResponse;
import net.polyv.live.v2.entity.user.children.LiveCreateUserChildrenRequest;
import net.polyv.live.v2.entity.user.children.LiveCreateUserChildrenResponse;
import net.polyv.live.v2.entity.user.children.LiveDeleteOrganizationRequest;
import net.polyv.live.v2.entity.user.children.LiveDeleteUserChildrenRequest;
import net.polyv.live.v2.entity.user.children.LiveGetChildrenRoleListRequest;
import net.polyv.live.v2.entity.user.children.LiveGetChildrenRoleListResponse;
import net.polyv.live.v2.entity.user.children.LiveGetOrganizationListRequest;
import net.polyv.live.v2.entity.user.children.LiveGetOrganizationListResponse;
import net.polyv.live.v2.entity.user.children.LiveGetUserChildrenRequest;
import net.polyv.live.v2.entity.user.children.LiveGetUserChildrenResponse;
import net.polyv.live.v2.entity.user.children.LiveUpdateUserChildrenRequest;

/**
 * 直播子账号管理
 * @author: jiangyifan
 */
public interface ILiveChildrenService {
    
    /**
     * 查询用户子账号列表
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/list
     * @param liveGetUserChildrenRequest 查询用户子账号列表请求实体
     * @return 查询用户子账号列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetUserChildrenResponse getUserChildren(LiveGetUserChildrenRequest liveGetUserChildrenRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 新增子账号
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/create
     * @param liveCreateUserChildrenRequest 新增子账号请求实体
     * @return 新增子账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveCreateUserChildrenResponse createUserChildren(LiveCreateUserChildrenRequest liveCreateUserChildrenRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改子账号
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/update
     * @param liveUpdateUserChildrenRequest 修改子账号请求实体
     * @return 修改子账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateUserChildren(LiveUpdateUserChildrenRequest liveUpdateUserChildrenRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除子账号
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/delete
     * @param liveDeleteUserChildrenRequest 删除子账号请求实体
     * @return 删除子账号响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteUserChildren(LiveDeleteUserChildrenRequest liveDeleteUserChildrenRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询角色列表
     * API地址：https://help.polyv.net/#/live/api/v4/user/children/role/list
     * @param liveGetChildrenRoleListRequest 查询角色列表请求实体
     * @return 查询角色列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveGetChildrenRoleListResponse> getChildrenRoleList(
            LiveGetChildrenRoleListRequest liveGetChildrenRoleListRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询组织架构列表
     * API地址：https://help.polyv.net/#/live/api/v4/user/organization/list
     * @param liveGetOrganizationListRequest 查询组织架构列表请求实体
     * @return 查询组织架构列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    List<LiveGetOrganizationListResponse> getOrganizationList(
            LiveGetOrganizationListRequest liveGetOrganizationListRequest) throws IOException, NoSuchAlgorithmException;
    
    /**
     * 新增组织
     * API地址：https://help.polyv.net/#/live/api/v4/user/organization/create
     * @param liveCreateOrganizationRequest 新增组织请求实体
     * @return 新增组织响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveCreateOrganizationResponse createOrganization(LiveCreateOrganizationRequest liveCreateOrganizationRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除组织
     * API地址：https://help.polyv.net/#/live/api/v4/user/organization/delete
     * @param liveDeleteOrganizationRequest 删除组织请求实体
     * @return 删除组织响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteOrganization(LiveDeleteOrganizationRequest liveDeleteOrganizationRequest)
            throws IOException, NoSuchAlgorithmException;
    
}
