package net.polyv.live.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;

import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.channel.viewdata.LiveChannelMaxHistoryConcurrentRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveChannelViewerConcurrenceRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveChannelViewerConcurrenceResponse;
import net.polyv.live.v1.entity.channel.viewdata.LiveGetChannelViewLogRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveGetChannelViewLogResponse;
import net.polyv.live.v1.entity.channel.viewdata.LiveGetSessionStatsRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveGetSessionStatsResponse;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelMicRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelMicResponse;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelSummaryRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelSummaryResponse;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelViewerCountRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelViewerCountResponse;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelViewlogRequest;
import net.polyv.live.v1.entity.channel.viewdata.LiveListChannelViewlogResponse;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelViewdataService;
import net.polyv.live.v2.entity.channel.viewdata.LiveChannelStatisticRequest;
import net.polyv.live.v2.entity.channel.viewdata.LiveChannelStatisticResponse;
import net.polyv.live.v2.entity.channel.viewdata.LiveDailySummaryRequest;
import net.polyv.live.v2.entity.channel.viewdata.LiveDailySummaryResponse;
import net.polyv.live.v2.entity.channel.viewdata.LiveGetLiveSessionRequest;
import net.polyv.live.v2.entity.channel.viewdata.LiveGetLiveSessionResponse;
import net.polyv.live.v2.entity.channel.viewdata.LiveListAccountViewlogRequest;
import net.polyv.live.v2.entity.channel.viewdata.LiveListAccountViewlogResponse;
import net.polyv.live.v2.entity.channel.viewdata.LiveListChannelLikeRequest;
import net.polyv.live.v2.entity.channel.viewdata.LiveListChannelLikeResponse;
import net.polyv.live.v2.entity.channel.viewdata.LiveListLinkMicDetailRequest;
import net.polyv.live.v2.entity.channel.viewdata.LiveListLinkMicDetailResponse;


/**
 * 直播观看数据实现类
 * @author: sadboy
 **/
public class LiveChannelViewdataServiceImpl extends LiveBaseService implements ILiveChannelViewdataService {
    
    /**
     * 获取频道一定时间范围之内的历史最高并发人数,粒度可以支持到分钟
     * API地址：https://dev.polyv.net/2020/liveproduct/l-api/zbglgn/gksj/get-max-history-concurrent/
     * @param liveChannelMaxHistoryConcurrentRequest 获取频道一定时间范围之内的历史最高并发人数请求实体
     * @return 获取频道一定时间范围之内的历史最高并发人数返回实体，返回并发人数，如：100
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Integer getMaxChannelHistoryConcurrent(
            LiveChannelMaxHistoryConcurrentRequest liveChannelMaxHistoryConcurrentRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_MAX_HISTORY_CONCURRENT_URL;
        Integer liveChannelMaxHistoryConcurrentResponse = (Integer) this.getReturnOne(url,
                liveChannelMaxHistoryConcurrentRequest, Integer.class);
        return liveChannelMaxHistoryConcurrentResponse;
    }
    
    /**
     * 分页获取连麦情况使用详情
     * API地址：https://dev.polyv.net/2020/liveproduct/l-api/zbglgn/gksj/mic-detail-list/
     * @param liveListChannelMicRequest 分页获取连麦情况使用详情请求实体
     * @return 分页获取连麦情况使用详情返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListChannelMicResponse listChannelMic(LiveListChannelMicRequest liveListChannelMicRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_MIC_LIST_URL;
        LiveListChannelMicResponse liveListChannelMicResponse = this.getReturnOne(url, liveListChannelMicRequest,
                LiveListChannelMicResponse.class);
        return liveListChannelMicResponse;
    }
    
    /**
     * 分页查询频道观看日志
     * 1. 如果查询一段时间的记录，可以传：startTime、endTime （startTime和endTime 必须在同一个月），如果查询某天的记录，则传currentDay；
     * 2. startTime、endTime 和 currentDay不能都不传；
     * 3. currentDay与startTime、endTime 同时传将使用currentDay的值。
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/zbglgn/gksj/viewlog-page/
     * @param liveChannelViewlogRequest 分页查询频道观看日志请求实体
     * @return 分页查询频道观看日志返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListChannelViewlogResponse listChannelViewlog(LiveListChannelViewlogRequest liveChannelViewlogRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHANNEL_VIEW_LOGS_GET_URL, liveChannelViewlogRequest.getChannelId());
        LiveListChannelViewlogResponse liveListChannelViewlogResponse = this.getReturnOne(url,
                liveChannelViewlogRequest, LiveListChannelViewlogResponse.class);
        return liveListChannelViewlogResponse;
    }
    
    /**
     * 查询多个频道汇总的统计数据
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/zbglgn/gksj/channel_play_summary/
     * @param liveListChannelSummaryRequest 查询多个频道汇总的统计数据请求实体
     * @return 查询多个频道汇总的统计数据返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListChannelSummaryResponse listChannelSummary(
            LiveListChannelSummaryRequest liveListChannelSummaryRequest) throws IOException, NoSuchAlgorithmException {
        liveListChannelSummaryRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl(LiveURL.CHANNEL_SUMMARY_LIST_GET_URL,
                liveListChannelSummaryRequest.getUserId());
        LiveListChannelSummaryResponse.ChannelSummary[] channelSummaries = this.postFormBodyReturnOne(url,
                liveListChannelSummaryRequest, LiveListChannelSummaryResponse.ChannelSummary[].class);
        channelSummaries =
                channelSummaries == null ? new LiveListChannelSummaryResponse.ChannelSummary[]{} : channelSummaries;
        LiveListChannelSummaryResponse liveListChannelSummaryResponse = new LiveListChannelSummaryResponse();
        liveListChannelSummaryResponse.setChannelSummarys(Arrays.asList(channelSummaries));
        return liveListChannelSummaryResponse;
    }
    
    /**
     * 查询多个频道的实时在线人数
     * API地址：https://dev.polyv.net/2018/liveproduct/l-api/zbglgn/gksj/get-realtime-viewers/
     * @param liveListChannelViewerCountRequest 查询多个频道的实时在线人数请求实体
     * @return 查询多个频道的实时在线人数返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListChannelViewerCountResponse listChannelViewerCount(
            LiveListChannelViewerCountRequest liveListChannelViewerCountRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_REAL_TIME_VIEWERS_GET_URL;
        LiveListChannelViewerCountResponse.ChannelViewerCount[] channelViewerCounts = this.getReturnOne(url,
                liveListChannelViewerCountRequest, LiveListChannelViewerCountResponse.ChannelViewerCount[].class);
        channelViewerCounts =
                channelViewerCounts == null ? new LiveListChannelViewerCountResponse.ChannelViewerCount[]{} :
                        channelViewerCounts;
        LiveListChannelViewerCountResponse liveListChannelViewerCountResponse =
                new LiveListChannelViewerCountResponse();
        liveListChannelViewerCountResponse.setChannelViewerCounts(Arrays.asList(channelViewerCounts));
        return liveListChannelViewerCountResponse;
    }
    
    /**
     * 查询频道的历史并发人数
     * API地址：https://dev.polyv.net/2019/liveproduct/l-api/zbglgn/gksj/concurrency/
     * @param liveChannelViewerConcurrenceRequest 查询频道的历史并发人数请求实体
     * @return 查询频道的历史并发人数返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveChannelViewerConcurrenceResponse getChannelViewerConcurrence(
            LiveChannelViewerConcurrenceRequest liveChannelViewerConcurrenceRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_VIEWER_CONCURRENCE_URL;
        LiveChannelViewerConcurrenceResponse.ChannelViewerConcurrence[] channelViewerConcurrences = this.getReturnOne(
                url, liveChannelViewerConcurrenceRequest,
                LiveChannelViewerConcurrenceResponse.ChannelViewerConcurrence[].class);
        channelViewerConcurrences = channelViewerConcurrences == null ?
                new LiveChannelViewerConcurrenceResponse.ChannelViewerConcurrence[]{} : channelViewerConcurrences;
        LiveChannelViewerConcurrenceResponse liveChannelViewerConcurrenceResponse =
                new LiveChannelViewerConcurrenceResponse();
        liveChannelViewerConcurrenceResponse.setChannelViewerConcurrences(Arrays.asList(channelViewerConcurrences));
        return liveChannelViewerConcurrenceResponse;
    }
    
    /**
     * 查询时间内直播场次数据
     * API地址：https://help.polyv.net/#/live/api/v4/channel/viewdata/get_live_session
     * @param liveGetLiveSessionRequest 查询时间内直播场次数据请求实体
     * @return 查询时间内直播场次数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetLiveSessionResponse getLiveSession(LiveGetLiveSessionRequest liveGetLiveSessionRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_SESSION_URL;
        return this.postFormBodyReturnOne(url, liveGetLiveSessionRequest, LiveGetLiveSessionResponse.class);
    }
    
    /**
     * 查询频道点赞详情
     * API地址：https://help.polyv.net/#/live/api/v4/channel/viewdata/like_list
     * @param liveListChannelLikeRequest 查询频道点赞详情请求实体
     * @return 查询频道点赞详情响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListChannelLikeResponse listChannelLike(LiveListChannelLikeRequest liveListChannelLikeRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_CHANNEL_LIKE_URL;
        return this.getReturnOne(url, liveListChannelLikeRequest, LiveListChannelLikeResponse.class);
    }
    
    /**
     * 分页查询账号直播观看详情数据
     * API地址：https://help.polyv.net/index.html#/live/api/channel/viewdata/viewlog_page_v3
     * @param liveGetChannelViewLogRequest 分页查询账号直播观看详情数据请求实体
     * @return 分页查询账号直播观看详情数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetChannelViewLogResponse getChannelViewLog(LiveGetChannelViewLogRequest liveGetChannelViewLogRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHANNEL_GET_VIEW_LOGS_URL;
        return this.getReturnOne(url, liveGetChannelViewLogRequest, LiveGetChannelViewLogResponse.class);
    }
    
    /**
     * 查询频道多场次概览统计数据
     * API地址：https://help.polyv.net/index.html#/live/api/channel/viewdata/get_session_stats
     * @param liveGetSessionStatsRequest 查询频道多场次概览统计数据请求实体
     * @return 查询频道多场次概览统计数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetSessionStatsResponse getSessionStats(LiveGetSessionStatsRequest liveGetSessionStatsRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_SESSION_STATS_URL;
        return this.getReturnOne(url, liveGetSessionStatsRequest, LiveGetSessionStatsResponse.class);
    }
    
    /**
     * 查询时间范围内频道直播观看详情数据
     * API地址：https://help.polyv.net/#/live/api/channel/viewdata/daily_summary
     * @param liveDailySummaryRequest 查询时间范围内频道直播观看详情数据请求实体
     * @return 查询时间范围内频道直播观看详情数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveDailySummaryResponse> getDailySummary(LiveDailySummaryRequest liveDailySummaryRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_DAILY_SUMMARY_URL;
        return this.getReturnList(url, liveDailySummaryRequest, LiveDailySummaryResponse.class);
    }
    
    /**
     * 查询频道连麦详情数据
     * API地址：https://help.polyv.net/#/live/api/channel/viewdata/link_mic_detail_list
     * @param liveListLinkMicDetailRequest 查询频道连麦详情数据请求实体
     * @return 查询频道连麦详情数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListLinkMicDetailResponse listLinkMicDetail(LiveListLinkMicDetailRequest liveListLinkMicDetailRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_LIST_LINK_MIC_DETAIL_URL;
        return this.getReturnOne(url, liveListLinkMicDetailRequest, LiveListLinkMicDetailResponse.class);
    }
    
    /**
     * 测试查询频道连麦详情数据
     * API地址：https://help.polyv.net/index.html#/live/api/channel/viewdata/channel_statistic
     * @param liveChannelStatisticRequest 测试查询频道连麦详情数据请求实体
     * @return 测试查询频道连麦详情数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveChannelStatisticResponse getChannelStatistic(LiveChannelStatisticRequest liveChannelStatisticRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_CHANNEL_STATISTICS_URL;
        return this.getReturnOne(url, liveChannelStatisticRequest, LiveChannelStatisticResponse.class);
    }
    
    /**
     * 分页查询账号观看记录
     * API地址：https://help.polyv.net/index.html#/live/api/v4/user/viewlog/viewlog_list
     * @param liveListAccountViewlogRequest 分页查询账号观看记录请求实体
     * @return 分页查询账号观看记录响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveListAccountViewlogResponse listAccountViewlog(
            LiveListAccountViewlogRequest liveListAccountViewlogRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_ACCOUNT_VIEWLOG_URL;
        return this.getReturnOne(url, liveListAccountViewlogRequest, LiveListAccountViewlogResponse.class);
    }
    
}
