package net.polyv.live.v1.entity.channel.product;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 添加频道商品响应实体
 * @author: jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("添加频道商品响应实体")
public class LiveAddProductResponse {
    
    /**
     * 商品productId
     */
    @ApiModelProperty(name = "productId", value = "商品productId", required = false)
    private Integer productId;
    
    /**
     * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * 商品名称，必填，长度范围：1-60
     */
    @ApiModelProperty(name = "name", value = "商品名称，长度范围：1-60", required = false)
    private String name;
    
    /**
     * 普通商品参数，商品原价，保留两位小数，如：0.01
     */
    @ApiModelProperty(name = "price", value = "普通商品参数，商品原价，保留两位小数，如：0.01", required = false)
    private Float price;
    
    /**
     * 商品封面链接
     */
    @ApiModelProperty(name = "cover", value = "商品封面链接", required = false)
    private String cover;
    
    /**
     * 商品通用类型商品链接
     */
    @ApiModelProperty(name = "link", value = "商品通用类型商品链接", required = false)
    private String link;
    
    /**
     * 商品上下架状态：1：上架，2：下架
     */
    @ApiModelProperty(name = "status", value = "商品上下架状态：1：上架，2：下架", required = false)
    private Integer status;
    
    /**
     * 创建商品时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "createdTime", value = "创建商品时间", required = false)
    private Date createdTime;
    
    /**
     * 更新商品时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "lastModified", value = "更新商品时间", required = false)
    private Date lastModified;
    
    /**
     * 商品排序号
     */
    @ApiModelProperty(name = "rank", value = "商品排序号", required = false)
    private Integer rank;
    
    /**
     * 商品实际价格，保留两位小数，如：0.01
     */
    @ApiModelProperty(name = "realPrice", value = "商品实际价格，保留两位小数，如：0.01", required = false)
    private Float realPrice;
    
    /**
     * 平台标志，默认live，其他无效
     */
    @ApiModelProperty(name = "type", value = "平台标志，默认live，其他无效", required = false)
    private String type;
    
    /**
     * 商品链接类型：10：通用链接，11：多平台链接
     */
    @ApiModelProperty(name = "linkType", value = "商品链接类型：10：通用链接，11：多平台链接", required = false)
    private Integer linkType;
    
    /**
     * 多平台链接，pc端跳转链接
     */
    @ApiModelProperty(name = "pcLink", value = "多平台链接，pc端跳转链接", required = false)
    private String pcLink;
    
    /**
     * 多平台链接，移动web端跳转链接
     */
    @ApiModelProperty(name = "mobileLink", value = "多平台链接，移动web端跳转链接", required = false)
    private String mobileLink;
    
    /**
     * 多平台链接，小程序端跳转链接
     */
    @ApiModelProperty(name = "wxMiniProgramLink", value = "多平台链接，小程序端跳转链接", required = false)
    @JSONField(name = "wxMiniprogramLink")
    private String wxMiniProgramLink;
    
    /**
     * 多平台链接，小程序端原始Id
     */
    @ApiModelProperty(name = "wxMiniProgramOriginalId", value = "多平台链接，小程序端原始Id", required = false)
    @JSONField(name = "wxMiniprogramOriginalId")
    private String wxMiniProgramOriginalId;
    
    /**
     * 多平台链接，移动App端跳转链接
     */
    @ApiModelProperty(name = "mobileAppLink", value = "多平台链接，移动App端跳转链接", required = false)
    private String mobileAppLink;
    
    /**
     * 多平台链接，移动APP-安卓系统原生页面链接
     */
    @ApiModelProperty(name = "androidLink", value = "多平台链接，移动APP-安卓系统原生页面链接", required = false)
    private String androidLink;
    
    /**
     * 多平台链接，移动APP-苹果系统原生页面链接
     */
    @ApiModelProperty(name = "mobileAppLink", value = "多平台链接，移动APP-苹果系统原生页面链接", required = false)
    private String iosLink;
    
    /**
     * 自定义参数，类型json对象，需要转为string
     */
    @ApiModelProperty(name = "params", value = "自定义参数，类型json对象，需要转为string", required = false)
    private String params;
    
    /**
     * 商品类型，normal：普通商品，finance：金融商品
     */
    @ApiModelProperty(name = "productType", value = "商品类型，normal：普通商品，finance：金融商品", required = false)
    private String productType;
    
    /**
     * 按钮显示文案
     */
    @ApiModelProperty(name = "btnShow", value = "按钮显示文案", required = false)
    private String btnShow;
    
    /**
     * 产品特色，卖点标签，可以多个，json字段，如：["tab1", "tab2"]
     */
    @ApiModelProperty(name = "features", value = "产品特色，卖点标签，可以多个，json字段，如：[\"tab1\", \"tab2\"]", required = false)
    private String features;
    
    /**
     * 产品描述
     */
    @ApiModelProperty(name = "productDesc", value = "产品描述", required = false)
    private String productDesc;
    
    /**
     * 金融商品参数，产品收益率/价格
     */
    @ApiModelProperty(name = "yield", value = "金融商品参数，产品收益率/价格", required = false)
    private String yield;
    
    /**
     * 商品详情，返回的是个内容存放的地址：例如 https://liveimages.videocc.net/product-info/product-detail/4d57ea01de/704007d1fdfd4cb2a5b3d3a842418831.json
     */
    @ApiModelProperty(name = "productDetail", value = "商品详情，返回的是个内容存放的地址：例如 https://liveimages.videocc.net/product-info/product-detail/4d57ea01de/704007d1fdfd4cb2a5b3d3a842418831.json url存放的就是商品详情内容", required = false)
    private String productDetail;
    
    /**
     * 价格类型，默认不填为金额 AMOUNT，自定义价格 CUSTOM
     */
    @ApiModelProperty(name = "priceType", value = "价格类型，默认不填为金额 AMOUNT，自定义价格 CUSTOM", required = false)
    private String priceType;
    
    /**
     * 购买价格-自定义，当priceType=CUSTOM时候生效
     */
    @ApiModelProperty(name = "customPrice", value = "购买价格-自定义，当priceType=CUSTOM时候生效", required = false)
    private String customPrice;
    
}
