package net.polyv.live.v1.entity.channel.product;

import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 添加频道商品请求实体
 * @author: jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("添加频道商品请求实体")
public class LiveAddProductRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 商品名称，必填，长度范围：1-60
     */
    @ApiModelProperty(name = "name", value = "商品名称，长度范围：1-60", required = true)
    @NotNull(message = "属性name不能为空")
    private String name;
    
    /**
     * 商品上下架状态：1：上架，2：下架
     */
    @ApiModelProperty(name = "status", value = "商品上下架状态：1：上架，2：下架", required = true)
    @NotNull(message = "属性status不能为空")
    private Integer status;
    
    /**
     * 商品链接类型：10：通用链接，11：多平台链接
     */
    @ApiModelProperty(name = "linkType", value = "商品链接类型：10：通用链接，11：多平台链接", required = true)
    @NotNull(message = "属性linkType不能为空")
    private Integer linkType;
    
    /**
     * 商品链接，链接地址长度为1-500：请求参数linkType=10时，该参数必填，当请求参数linkType=11时，该参数为非必填
     */
    @ApiModelProperty(name = "link", value = "商品链接，链接地址长度为1-500：请求参数linkType=10时，该参数必填，当请求参数linkType=11" +
            "时，该参数为非必填", required = false)
    private String link;
    
    /**
     * 多平台链接，pc端跳转链接，链接地址长度为1-500：请求参数linkType=10时，该参数非必填，当请求参数linkType=11时，该参数必填
     */
    @ApiModelProperty(name = "pcLink", value = "多平台链接，pc端跳转链接，链接地址长度为1-500：请求参数linkType=10时，该参数非必填，当请求参数linkType=11" +
            "时，该参数必填", required = false)
    private String pcLink;
    
    /**
     * 多平台链接，移动web端链接
     */
    @ApiModelProperty(name = "mobileLink", value = "多平台链接，移动web端链接", required = false)
    private String mobileLink;
    
    /**
     * 多平台链接，小程序内页面路径及参数（对于path属性，所声明的页面路径必须添加.html后缀，如pages/home/index.html）
     */
    @ApiModelProperty(name = "wxMiniProgramLink", value = "多平台链接，小程序内页面路径及参数（对于path属性，所声明的页面路径必须添加" +
            ".html后缀，如pages/home/index.html）", required = false)
    @JSONField(name = "wxMiniprogramLink")
    private String wxMiniProgramLink;
    
    /**
     * 多平台链接，小程序端原始Id
     */
    @ApiModelProperty(name = "wxMiniProgramOriginalId", value = "多平台链接，小程序端原始Id", required = false)
    @JSONField(name = "wxMiniprogramOriginalId")
    private String wxMiniProgramOriginalId;
    
    /**
     * 多平台链接，移动App端链接
     */
    @ApiModelProperty(name = "mobileAppLink", value = "多平台链接，移动App端链接", required = false)
    private String mobileAppLink;
    
    /**
     * 多平台链接，移动APP-安卓系统原生页面链接
     */
    @ApiModelProperty(name = "androidLink", value = "多平台链接，移动APP-安卓系统原生页面链接", required = false)
    private String androidLink;
    
    /**
     * 多平台链接，移动APP-苹果系统原生页面链接
     */
    @ApiModelProperty(name = "mobileAppLink", value = "多平台链接，移动APP-苹果系统原生页面链接", required = false)
    private String iosLink;
    
    /**
     * 自定义参数，类型json对象，需要转为string
     */
    @ApiModelProperty(name = "params", value = "自定义参数，类型json对象，需要转为string", required = false)
    private String params;
    
    /**
     * 产品描述
     */
    @ApiModelProperty(name = "productDesc", value = "产品描述", required = false)
    private String productDesc;
    
    /**
     * 产品特色，卖点标签，可以多个，json字段，如：["tab1", "tab2"]
     */
    @ApiModelProperty(name = "features", value = "产品特色，卖点标签，可以多个，json字段，如：[\"tab1\", \"tab2\"]", required = false)
    private String features;
    
    /**
     * 普通商品参数，商品封面链接，商品类型为普通商品时必传，长度范围：1-500
     */
    @ApiModelProperty(name = "cover", value = "普通商品参数，商品封面链接，商品类型为普通商品时必传，长度范围：1-500", required = false)
    private String cover;
    
    /**
     * 普通商品参数，商品实际价格，商品类型为普通商品时必传，保留两位小数，如：0.01
     */
    @ApiModelProperty(name = "realPrice", value = "普通商品参数，商品实际价格，商品类型为普通商品时必传，保留两位小数，如：0.01", required = false)
    private Float realPrice;
    
    /**
     * 普通商品参数，商品原价，保留两位小数，如：0.01
     */
    @ApiModelProperty(name = "price", value = "普通商品参数，商品原价，保留两位小数，如：0.01", required = false)
    private Float price;
    
    /**
     * 金融商品参数，按钮显示文案
     */
    @ApiModelProperty(name = "btnShow", value = "金融商品参数，按钮显示文案", required = false)
    private String btnShow;
    
    /**
     * 金融商品参数，产品收益率/价格
     */
    @ApiModelProperty(name = "yield", value = "金融商品参数，产品收益率/价格", required = false)
    private String yield;
    
    /**
     * 商品类型，默认为普通商品：normal：普通商品，finance：金融商品
     */
    @ApiModelProperty(name = "productType", value = "商品类型，默认为普通商品：normal：普通商品，finance：金融商品", required = false)
    private String productType;
    
    /**
     * 平台商品id，（有值则平台商品库复制新建频道商品，此时其他字段只有status为必填）
     */
    @ApiModelProperty(name = "originId", value = "平台商品id，（有值则平台商品库复制新建频道商品，此时其他字段只有status为必填）", required = false)
    private String originId;
    
    /**
     * originId非空时的复制平台商品的策略，可选值: copy-复制, ref-引用(推荐使用此值)，默认值为copy (引用平台商品库的商品：平台商品库改动商品字段，会自动同步到频道商品库中
     * 拷贝平台商品库的商品：平台商品库改动商品字段，不会自动同步到频道商品库中)
     */
    @ApiModelProperty(name = "strategy", value = "originId非空时的复制平台商品的策略，可选值: copy-复制, ref-引用(推荐使用此值)，默认值为copy (引用平台商品库的商品：平台商品库改动商品字段，会自动同步到频道商品库中\n" +
            "拷贝平台商品库的商品：平台商品库改动商品字段，不会自动同步到频道商品库中)", required = false)
    private String strategy;
    
    /**
     * 商品详情，普通商品显示
     */
    @ApiModelProperty(name = "productDetail", value = "商品详情，普通商品显示", required = false)
    private String productDetail;
    
    /**
     * 价格类型，默认不填为为金额 AMOUNT，自定义价格 CUSTOM
     */
    @ApiModelProperty(name = "priceType", value = "价格类型，默认不填为为金额 AMOUNT，自定义价格 CUSTOM", required = false)
    private String priceType;
    
    /**
     * 购买价格-自定义，当priceType=CUSTOM时候生效
     */
    @ApiModelProperty(name = "customPrice", value = "购买价格-自定义，当priceType=CUSTOM时候生效", required = false)
    private String customPrice;
    
    /**
     * 扩展信息
     */
    @ApiModelProperty(name = "extObject", value = "扩展信息对象", required = false)
    private ExtObject extObject;
    
    /**
     * Java SDK程序自动设置的扩展字段，无需手动设置
     */
    @ApiModelProperty(hidden = true, value = "Java SDK程序自动设置的扩展字段，无需手动设置", required = false)
    private String ext;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("扩展信息对象")
    public static class ExtObject {
        
        /**
         * 封面图地址数组，最多15个
         */
        @ApiModelProperty(name = "coverList", value = "封面图地址数组，最多15个", required = false)
        private List<String> coverList;
        
        /**
         * 视频数组，最多1个,需要开通素材库才能使用
         */
        @ApiModelProperty(name = "videoList", value = "视频数组，最多1个,需要开通素材库才能使用", required = false)
        private List<Video> videoList;
    
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("视频地址对象")
    public static class Video {
        
        /**
         * 视频ID
         */
        @ApiModelProperty(name = "videoId", value = "视频ID", required = false)
        private String videoId;
        
        /**
         * 视频来源： MATERIAL_LIBRARY-素材库
         */
        @ApiModelProperty(name = "videoSource", value = "视频来源： MATERIAL_LIBRARY-素材库", required = false)
        private String videoSource;
    
    }
    
}
