/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.interact.impl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.interact.ILiveLotteryActivityService;
import net.polyv.live.v1.util.LiveSignUtil;
import net.polyv.live.v2.entity.channel.interact.LiveCreateLotteryActivityRequest;
import net.polyv.live.v2.entity.channel.interact.LiveCreateLotteryActivityResponse;
import net.polyv.live.v2.entity.channel.interact.LiveDeleteLotteryActivityRequest;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityListPageResponse;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityListRequest;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityRequest;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityResponse;
import net.polyv.live.v2.entity.channel.interact.LiveUpdateLotteryActivityRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveLotteryActivityServiceImpl
extends LiveBaseService
implements ILiveLotteryActivityService {
    private static final Logger log = LoggerFactory.getLogger(LiveLotteryActivityServiceImpl.class);

    @Override
    public LiveLotteryActivityResponse getLotteryActivity(LiveLotteryActivityRequest liveLotteryActivityRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live//v4/channel/lottery-activity/get";
        return super.getReturnOne(url, liveLotteryActivityRequest, LiveLotteryActivityResponse.class);
    }

    @Override
    public LiveCreateLotteryActivityResponse createLotteryActivity(LiveCreateLotteryActivityRequest liveCreateLotteryActivityRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live//v4/channel/lottery-activity/create";
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveCreateLotteryActivityRequest);
        signMap.put("channelId", liveCreateLotteryActivityRequest.getChannelId());
        return super.postJsonBodyReturnOne(url, signMap, liveCreateLotteryActivityRequest, JSON.toJSONString(liveCreateLotteryActivityRequest), LiveCreateLotteryActivityResponse.class);
    }

    @Override
    public Boolean updateLotteryActivity(LiveUpdateLotteryActivityRequest liveUpdateLotteryActivityRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live//v4/channel/lottery-activity/update";
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveUpdateLotteryActivityRequest);
        signMap.put("channelId", liveUpdateLotteryActivityRequest.getChannelId());
        super.postJsonBodyReturnOne(url, signMap, liveUpdateLotteryActivityRequest, JSON.toJSONString(liveUpdateLotteryActivityRequest), Boolean.class);
        return true;
    }

    @Override
    public Boolean deleteLotteryActivity(LiveDeleteLotteryActivityRequest liveDeleteLotteryActivityRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live//v4/channel/lottery-activity/delete";
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveDeleteLotteryActivityRequest);
        signMap.put("channelId", liveDeleteLotteryActivityRequest.getChannelId());
        super.postJsonBodyReturnOne(url, signMap, liveDeleteLotteryActivityRequest, JSON.toJSONString(liveDeleteLotteryActivityRequest), Boolean.class);
        return true;
    }

    @Override
    public LiveLotteryActivityListPageResponse listLotteryActivity(LiveLotteryActivityListRequest liveLotteryActivityListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live//v4/channel/lottery-activity/list";
        return super.getReturnOne(url, liveLotteryActivityListRequest, LiveLotteryActivityListPageResponse.class);
    }
}

