package net.polyv.live.v2.entity.user.children;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询用户子账号列表响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询用户子账号列表响应实体")
public class LiveGetUserChildrenResponse extends LivePageCommonResponse {
    
    /**
     * 子账号信息
     */
    @ApiModelProperty(name = "contents", value = "子账号信息", required = false)
    private List<LiveGetUserChildrenResponse.UserChildren> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("子账号信息")
    public static class UserChildren {
        
        /**
         * 子账号用户Id
         */
        @ApiModelProperty(name = "childUserId", value = "子账号用户Id", required = false)
        private String childUserId;
        
        /**
         * 子账号用户名
         */
        @ApiModelProperty(name = "childName", value = "子账号用户名", required = false)
        private String childName;
        
        /**
         * 子账号邮箱
         */
        @ApiModelProperty(name = "childEmail", value = "子账号邮箱", required = false)
        private String childEmail;
        
        /**
         * 描述
         */
        @ApiModelProperty(name = "description", value = "描述", required = false)
        private String description;
        
        /**
         * 手机号码
         */
        @ApiModelProperty(name = "telephone", value = "手机号码", required = false)
        private String telephone;
        
        /**
         * 状态 NORMAL：正常 FROZEN：冻结 DELETE：删除
         */
        @ApiModelProperty(name = "status", value = "状态 NORMAL：正常 FROZEN：冻结 DELETE：删除", required = false)
        private String status;
        
        /**
         * 所属用户组织架构ID
         */
        @ApiModelProperty(name = "organizationId", value = "所属用户组织架构ID", required = false)
        private Integer organizationId;
        
        /**
         * 所属用户组织架构名称
         */
        @ApiModelProperty(name = "organizationName", value = "所属用户组织架构名称", required = false)
        private String organizationName;
        
        /**
         * 所属角色ID
         */
        @ApiModelProperty(name = "roleId", value = "所属角色ID", required = false)
        private Integer roleId;
        
        /**
         * 所属角色名称
         */
        @ApiModelProperty(name = "roleName", value = "所属角色名称", required = false)
        private String roleName;
        
        /**
         * 创建时间，13位毫秒级时间戳
         */
        @ApiModelProperty(name = "createdTime", value = "创建时间，13位毫秒级时间戳", required = false)
        private Date createdTime;
    }
}