package net.polyv.live.v2.entity.chat;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 发送开播端弹窗消息请求实体
 * @author sadboy
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("发送开播端弹窗消息请求实体")
public class LiveAlertChatSpecialRequest extends LiveCommonRequest {
    
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 标题，长度大于等于1，长度小于等于100
     */
    @ApiModelProperty(name = "title", value = "标题<br/>长度大于等于1，长度小于等于100", required = true)
    @NotNull(message = "属性title不能为空")
    private String title;
    
    /**
     * 消息说明，长度大于等于1，长度小于等于500
     */
    @ApiModelProperty(name = "message", value = "消息说明<br/>长度大于等于1，长度小于等于500", required = true)
    @NotNull(message = "属性message不能为空")
    private String message;

}
