package net.polyv.live.v2.entity.channel.web.interact.share;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道微信分享信息响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道微信分享信息响应实体")
public class LiveGetChannelShareResponse {
    
    /**
     * 是否开启分享，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "shareBtnEnable", value = "是否开启分享，Y：开启，N：关闭", required = false)
    private String shareBtnEnable;
    
    /**
     * 标题类型follow直播标题、custom自定义
     */
    @ApiModelProperty(name = "titleType", value = "标题类型follow直播标题、custom自定义", required = false)
    private String titleType;
    
    /**
     * 分享标题，最大长度50，标题类型为custom时，该字段生效
     */
    @ApiModelProperty(name = "weixinShareTitle", value = "分享标题，最大长度50，标题类型为custom时，该字段生效", required = false)
    private String weixinShareTitle;
    
    /**
     * 分享简介，最大长度120，标题类型为custom时，该字段生效
     */
    @ApiModelProperty(name = "weixinShareDesc", value = "分享简介，最大长度120，标题类型为custom时，该字段生效", required = false)
    private String weixinShareDesc;
    
    /**
     * 微信自定义分享地址，最大长度512
     */
    @ApiModelProperty(name = "weixinShareCustomUrl", value = "微信自定义分享地址，最大长度512", required = false)
    private String weixinShareCustomUrl;
    
    /**
     * 网页观看自定义分享地址，最大长度512
     */
    @ApiModelProperty(name = "webShareCustomUrl", value = "网页观看自定义分享地址，最大长度512", required = false)
    private String webShareCustomUrl;
    
}