package net.polyv.live.v2.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 删除重制课件任务请求实体
 * @author liyongxuan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("删除重制课件任务请求实体")
public class LiveDeleteChannelPPTRecordRequest extends LiveCommonRequest {
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 任务ID列表，多个任务ID使用”,”进行分隔
     */
    @ApiModelProperty(name = "taskIds", value = "任务ID列表，多个任务ID使用”,”进行分隔", required = true)
    @NotNull(message = "属性taskIds不能为空")
    private String taskIds;
    
}