package net.polyv.live.v2.entity.channel.interact;

import java.math.BigDecimal;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;


/**
 * 更新抽奖活动请求实体
 * @author sadboy
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("更新抽奖活动请求实体")
public class LiveUpdateLotteryActivityRequest extends LiveCommonRequest {

    /**
     * 频道号
     */
    @NotNull(message = "属性channelId不能为空")
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    private String channelId;
    
    /**
     * 抽奖活动ID
     */
    @NotNull(message = "属性id不能为空")
    @ApiModelProperty(name = "id", value = "抽奖活动ID", required = true)
    private Long id;

    /**
     * 抽奖活动名称
     */
    @NotNull(message = "属性activityName不能为空")
    @ApiModelProperty(name = "activityName", value = "抽奖活动名称", required = true)
    private String activityName;

    /**
     * 抽奖活动类型, none:无条件, invite:邀请好友, duration:观看时长, comment:评论抽奖, question:答题抽奖
     */
    @NotNull(message = "属性lotteryCondition不能为空")
    @ApiModelProperty(name = "lotteryCondition", value = "抽奖活动类型, none:无条件, invite:邀请好友, duration:观看时长, comment:评论抽奖, question:答题抽奖", required = true)
    private String lotteryCondition;

    /**
     * 中奖人数
     */
    @NotNull(message = "属性amount不能为空")
    @ApiModelProperty(name = "amount", value = "中奖人数", required = true)
    private Integer amount;

    /**
     * 是否隐藏中奖人数, 值:Y/N, 默认N
     */
    @ApiModelProperty(name = "hiddenWinnerAmount", value = "是否隐藏中奖人数, 值:Y/N, 默认N", required = false)
    private String hiddenWinnerAmount;

    /**
     * 参与抽奖用户类型: all:全部，customGroup:自定义分组
     */
    @ApiModelProperty(name = "lotteryRange", value = "参与抽奖用户类型: all:全部，customGroup:自定义分组", required = false)
    private String lotteryRange;

    /**
     * 分组抽取方式, average:等额抽奖, random:随机抽奖
     */
    @ApiModelProperty(name = "customGroupLotteryType", value = "分组抽取方式, average:等额抽奖, random:随机抽奖", required = false)
    private String customGroupLotteryType;

    /**
     * 每组抽取数量
     */
    @ApiModelProperty(name = "customGroupLotteryAmount", value = "每组抽取数量", required = false)
    private Integer customGroupLotteryAmount;

    /**
     * 是否隐藏参与人数, 值:Y/N, 默认N
     */
    @ApiModelProperty(name = "hiddenAttendeeNumber", value = "是否隐藏参与人数, 值:Y/N, 默认N", required = false)
    private String hiddenAttendeeNumber;

    /**
     * 允许重复中奖, 值:Y/N, 默认N
     */
    @ApiModelProperty(name = "repeatWinEnabled", value = "允许重复中奖, 值:Y/N, 默认N", required = false)
    private String repeatWinEnabled;

    /**
     * 是否填写收货信息, 值:Y/N, 默认N
     */
    @ApiModelProperty(name = "receiveEnabled", value = "是否填写收货信息, 值:Y/N, 默认N", required = false)
    private String receiveEnabled;

    /**
     * 奖品名称
     */
    @NotNull(message = "属性prizeName不能为空")
    @ApiModelProperty(name = "prizeName", value = "奖品名称", required = true)
    private String prizeName;

    /**
     * 奖品图片
     */
    @ApiModelProperty(name = "thumbnail", value = "奖品图片", required = false)
    private String thumbnail;

    /**
     * 活动时长(分钟)，非无条件抽奖时必填
     */
    @ApiModelProperty(name = "activityDuration", value = "活动时长(分钟)，非无条件抽奖时必填", required = false)
    private String activityDuration;

    /**
     * 邀请方式，poster:邀请海报，external:外部邀请，邀请抽奖时必填
     */
    @ApiModelProperty(name = "inviteType", value = "邀请方式，poster:邀请海报，external:外部邀请，邀请抽奖时必填", required = false)
    private String inviteType;

    /**
     * 外部名单链接，邀请抽奖且邀请方式为外部邀请时必填
     */
    @ApiModelProperty(name = "externalListLink", value = "外部名单链接，邀请抽奖且邀请方式为外部邀请时必填", required = false)
    private String externalListLink;

    /**
     * 获取邀请人数链接，邀请抽奖且邀请方式为外部邀请时必填
     */
    @ApiModelProperty(name = "externalInviteNumLink", value = "获取邀请人数链接，邀请抽奖且邀请方式为外部邀请时必填", required = false)
    private String externalInviteNumLink;

    /**
     * 邀请人数，邀请抽奖时必填
     */
    @ApiModelProperty(name = "inviteNum", value = "邀请人数，邀请抽奖时必填", required = false)
    private Integer inviteNum;

    /**
     * 观看时长，观看时长抽奖时必填
     */
    @ApiModelProperty(name = "duration", value = "观看时长，观看时长抽奖时必填", required = false)
    private Integer duration;

    /**
     * 评论内容，评论抽奖时必填
     */
    @ApiModelProperty(name = "comment", value = "评论内容，评论抽奖时必填", required = false)
    private String comment;

    /**
     * 领奖方式，form:表单，link:外链，qrCode:识别二维码, 非无条件和答题抽奖必填
     */
    @ApiModelProperty(name = "acceptType", value = "领奖方式，form:表单，link:外链，qrCode:识别二维码, 非无条件和答题抽奖必填", required = false)
    private String acceptType;

    /**
     * 领奖方式奖品链接, 领奖方式为外链必填
     */
    @ApiModelProperty(name = "prizeUrl", value = "领奖方式奖品链接, 领奖方式为外链必填", required = false)
    private String prizeUrl;

    /**
     * 领奖方式二维码链接, 领奖方式为二维码必填
     */
    @ApiModelProperty(name = "qrCode", value = "领奖方式二维码链接, 领奖方式为二维码必填", required = false)
    private String qrCode;

    /**
     * 领奖方式二维码提示语, 领奖方式为二维码填写
     */
    @ApiModelProperty(name = "qrCodeTips", value = "领奖方式二维码提示语, 领奖方式为二维码填写", required = false)
    private String qrCodeTips;

    /**
     * 优惠价格
     */
    @ApiModelProperty(name = "realPrice", value = "优惠价格", required = false)
    private BigDecimal realPrice;

    /**
     * 奖品原价
     */
    @ApiModelProperty(name = "price", value = "奖品原价", required = false)
    private BigDecimal price;

    /**
     * 问答组模板ID, 答题抽奖必填
     */
    @ApiModelProperty(name = "questionGroupId", value = "问答组模板ID, 答题抽奖必填", required = false)
    private Long questionGroupId;

    /**
     * 每道题的答题时长, 答题抽奖必填
     */
    @ApiModelProperty(name = "perAnswerDuration", value = "每道题的答题时长, 答题抽奖必填", required = false)
    private Integer perAnswerDuration;

    /**
     * 收货字段信息列表，无条件抽奖时填写
     */
    @ApiModelProperty(name = "receiveInfo", value = "收货字段信息列表，无条件抽奖时填写", required = false)
    private List<LiveCreateLotteryActivityRequest.ReceiveInfo> receiveInfo;

    /**
     * 领奖方式表单字段信息, 领奖方式为表单填写
     */
    @ApiModelProperty(name = "formInfo", value = "领奖方式表单字段信息, 领奖方式为表单填写", required = false)
    private List<LiveCreateLotteryActivityRequest.ReceiveInfo> formInfo;

    /**
     * 奖品信息，答题抽奖时必填
     */
    @ApiModelProperty(name = "prizeInfo", value = "奖品信息，答题抽奖时必填", required = false)
    private List<LiveCreateLotteryActivityRequest.PrizeInfo> prizeInfo;

    @Data
    @Accessors(chain = true)
    @ApiModel("收货字段信息")
    public static class ReceiveInfo{

        /**
         * 类型, userName:姓名、userPhone:手机号、custom:自定义
         */
        @ApiModelProperty(name = "type", value = "类型, userName:姓名、userPhone:手机号、custom:自定义", required = false)
        private String type;

        /**
         * 字段名
         */
        @NotNull(message = "属性field不能为空")
        @ApiModelProperty(name = "field", value = "字段名", required = true)
        private String field;

        /**
         * 提示语
         */
        @NotNull(message = "属性tips不能为空")
        @ApiModelProperty(name = "tips", value = "提示语", required = true)
        private String tips;

        /**
         * 是否必填，true/false
         */
        @ApiModelProperty(name = "required", value = "是否必填，true/false", required = false)
        private Boolean required;

    }

    @Data
    @Accessors(chain = true)
    @ApiModel("奖品信息")
    public static class PrizeInfo{

        /**
         * 奖项名称
         */
        @NotNull(message = "属性prizeItem不能为空")
        @ApiModelProperty(name = "prizeItem", value = "奖项名称", required = true)
        private String prizeItem;

        /**
         * 答对题目数
         */
        @NotNull(message = "属性correctAnswerCount不能为空")
        @ApiModelProperty(name = "correctAnswerCount", value = "答对题目数", required = true)
        private Integer correctAnswerCount;

        /**
         * 奖品名称
         */
        @NotNull(message = "属性prizeName不能为空")
        @ApiModelProperty(name = "prizeName", value = "奖品名称", required = true)
        private String prizeName;

        /**
         * 奖品图片
         */
        @ApiModelProperty(name = "thumbnail", value = "奖品图片", required = false)
        private String thumbnail;

        /**
         * 优惠价格
         */
        @ApiModelProperty(name = "realPrice", value = "优惠价格", required = false)
        private BigDecimal realPrice;

        /**
         * 奖品原价
         */
        @ApiModelProperty(name = "price", value = "奖品原价", required = false)
        private BigDecimal price;

        /**
         * 领奖方式，form:表单，link:外链，qrCode:识别二维码
         */
        @NotNull(message = "属性acceptType不能为空")
        @ApiModelProperty(name = "acceptType", value = "领奖方式，form:表单，link:外链，qrCode:识别二维码", required = true)
        private String acceptType;

        /**
         * 领奖方式奖品链接, 领奖方式为外链必填
         */
        @ApiModelProperty(name = "prizeUrl", value = "领奖方式奖品链接, 领奖方式为外链必填", required = false)
        private String prizeUrl;

        /**
         * 领奖方式二维码链接, 领奖方式为二维码必填
         */
        @ApiModelProperty(name = "qrCode", value = "领奖方式二维码链接, 领奖方式为二维码必填", required = false)
        private String qrCode;

        /**
         * 领奖方式二维码提示语, 领奖方式为二维码填写
         */
        @ApiModelProperty(name = "qrCodeTips", value = "领奖方式二维码提示语, 领奖方式为二维码填写", required = false)
        private String qrCodeTips;

        /**
         * 中奖人数
         */
        @NotNull(message = "属性amount不能为空")
        @ApiModelProperty(name = "amount", value = "中奖人数", required = true)
        private Integer amount;

        /**
         * 是否隐藏中奖人数, 值:Y/N, 默认N
         */
        @ApiModelProperty(name = "hiddenWinnerAmount", value = "是否隐藏中奖人数, 值:Y/N, 默认N", required = false)
        private String hiddenWinnerAmount;

        /**
         * 领奖方式表单字段信息, 领奖方式为表单填写
         */
        @ApiModelProperty(name = "formInfo", value = "领奖方式表单字段信息, 领奖方式为表单填写", required = false)
        private List<LiveCreateLotteryActivityRequest.ReceiveInfo> formInfo;

    }

}
