package net.polyv.live.v2.entity.channel.interact;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询抽奖活动请求实体
 * @author sadboy
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询抽奖活动请求实体")
public class LiveLotteryActivityRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @NotNull(message = "属性channelId不能为空")
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    private String channelId;
    
    /**
     * 抽奖活动id
     */
    @NotNull(message = "属性id不能为空")
    @ApiModelProperty(name = "id", value = "抽奖活动id", required = true)
    private Long id;
    
}
