package net.polyv.live.v2.entity.channel.interact;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.math.BigDecimal;
import java.util.List;

/**
 * 创建抽奖活动返回实体
 * @author sadboy
 */
@Data
@Accessors(chain = true)
@ApiModel("创建抽奖活动返回实体")
public class LiveCreateLotteryActivityResponse {

    /**
     * 抽奖活动ID
     */
    @ApiModelProperty(name = "id", value = "抽奖活动ID", required = false)
    private Long id;

    /**
     * 抽奖活动名称
     */
    @ApiModelProperty(name = "activityName", value = "抽奖活动名称", required = false)
    private String activityName;

    /**
     * 抽奖类型
     */
    @ApiModelProperty(name = "lotteryCondition", value = "抽奖类型", required = false)
    private String lotteryCondition;

    /**
     * 抽奖活动状态
     */
    @ApiModelProperty(name = "status", value = "抽奖活动状态", required = false)
    private String status;

    /**
     * 中奖人数
     */
    @ApiModelProperty(name = "amount", value = "中奖人数", required = false)
    private Integer amount;

    /**
     * 是否隐藏中奖人数
     */
    @ApiModelProperty(name = "hiddenWinnerAmount", value = "是否隐藏中奖人数", required = false)
    private String hiddenWinnerAmount;

    /**
     * 参与抽奖用户类型: all:全部，customGroup:自定义分组
     */
    @ApiModelProperty(name = "lotteryRange", value = "参与抽奖用户类型: all:全部，customGroup:自定义分组", required = false)
    private String lotteryRange;

    /**
     * 分组抽取方式, average:等额抽奖, random:随机抽奖
     */
    @ApiModelProperty(name = "customGroupLotteryType", value = "分组抽取方式, average:等额抽奖, random:随机抽奖", required = false)
    private String customGroupLotteryType;

    /**
     * 每组抽取数量
     */
    @ApiModelProperty(name = "customGroupLotteryAmount", value = "每组抽取数量", required = false)
    private Integer customGroupLotteryAmount;

    /**
     * 是否隐藏参与人数
     */
    @ApiModelProperty(name = "hiddenAttendeeNumber", value = "是否隐藏参与人数", required = false)
    private String hiddenAttendeeNumber;

    /**
     * 允许重复中奖
     */
    @ApiModelProperty(name = "repeatWinEnabled", value = "允许重复中奖", required = false)
    private String repeatWinEnabled;

    /**
     * 是否填写收货信息
     */
    @ApiModelProperty(name = "receiveEnabled", value = "是否填写收货信息", required = false)
    private String receiveEnabled;

    /**
     * 奖品名称
     */
    @ApiModelProperty(name = "prizeName", value = "奖品名称", required = false)
    private String prizeName;

    /**
     * 奖品图片
     */
    @ApiModelProperty(name = "thumbnail", value = "奖品图片", required = false)
    private String thumbnail;

    /**
     * 活动时长(分钟)
     */
    @ApiModelProperty(name = "activityDuration", value = "活动时长(分钟)", required = false)
    private String activityDuration;

    /**
     * 邀请方式
     */
    @ApiModelProperty(name = "inviteType", value = "邀请方式", required = false)
    private String inviteType;

    /**
     * 外部名单链接
     */
    @ApiModelProperty(name = "externalListLink", value = "外部名单链接", required = false)
    private String externalListLink;

    /**
     * 获取邀请人数链接
     */
    @ApiModelProperty(name = "externalInviteNumLink", value = "获取邀请人数链接", required = false)
    private String externalInviteNumLink;

    /**
     * 邀请人数
     */
    @ApiModelProperty(name = "inviteNum", value = "邀请人数", required = false)
    private Integer inviteNum;

    /**
     * 观看时长
     */
    @ApiModelProperty(name = "duration", value = "观看时长", required = false)
    private Integer duration;

    /**
     * 评论内容
     */
    @ApiModelProperty(name = "comment", value = "评论内容", required = false)
    private String comment;

    /**
     * 领奖方式，form:表单，link:外链，qrCode:识别二维码,
     */
    @ApiModelProperty(name = "acceptType", value = "领奖方式，form:表单，link:外链，qrCode:识别二维码,", required = false)
    private String acceptType;

    /**
     * 领奖方式奖品链接
     */
    @ApiModelProperty(name = "prizeUrl", value = "领奖方式奖品链接", required = false)
    private String prizeUrl;

    /**
     * 领奖方式二维码链接
     */
    @ApiModelProperty(name = "qrCode", value = "领奖方式二维码链接", required = false)
    private String qrCode;

    /**
     * 领奖方式二维码提示语
     */
    @ApiModelProperty(name = "qrCodeTips", value = "领奖方式二维码提示语", required = false)
    private String qrCodeTips;

    /**
     * 优惠价格
     */
    @ApiModelProperty(name = "realPrice", value = "优惠价格", required = false)
    private BigDecimal realPrice;

    /**
     * 奖品原价
     */
    @ApiModelProperty(name = "price", value = "奖品原价", required = false)
    private BigDecimal price;

    /**
     * 问答组模板ID
     */
    @ApiModelProperty(name = "questionGroupId", value = "问答组模板ID", required = false)
    private Long questionGroupId;

    /**
     * 每道题的答题时长
     */
    @ApiModelProperty(name = "perAnswerDuration", value = "每道题的答题时长", required = false)
    private Integer perAnswerDuration;

    /**
     * 自定义分组信息
     */
    @ApiModelProperty(name = "customGroup", value = "自定义分组信息", required = false)
    private List<CustomGroup> customGroup;

    /**
     * 收货字段信息列表，无条件抽奖时填写
     */
    @ApiModelProperty(name = "receiveInfo", value = "收货字段信息列表，无条件抽奖时填写", required = false)
    private List<ReceiveInfo> receiveInfo;

    /**
     * 领奖方式表单字段信息
     */
    @ApiModelProperty(name = "formInfo", value = "领奖方式表单字段信息", required = false)
    private List<ReceiveInfo> formInfo;

    /**
     * 奖品信息
     */
    @ApiModelProperty(name = "prizeInfo", value = "奖品信息", required = false)
    private List<PrizeInfo> prizeInfo;

    @Data
    @Accessors(chain = true)
    @ApiModel("自定义分组信息")
    public static class CustomGroup {

        /**
         * 分组ID
         */
        @ApiModelProperty(name = "id", value = "分组ID", required = false)
        private Long id;

        /**
         * 分组标题
         */
        @ApiModelProperty(name = "title", value = "分组标题", required = false)
        private String title;

        /**
         * 分组类型
         */
        @ApiModelProperty(name = "type", value = "分组类型", required = false)
        private String type;

        /**
         * 分组人数
         */
        @ApiModelProperty(name = "count", value = "分组人数", required = false)
        private String count;

    }

    @Data
    @Accessors(chain = true)
    @ApiModel("收货字段信息列表，无条件抽奖时填写")
    public static class ReceiveInfo {

        /**
         * 类型, userName:姓名、userPhone:手机号、custom:自定义
         */
        @ApiModelProperty(name = "type", value = "类型, userName:姓名、userPhone:手机号、custom:自定义", required = false)
        private String type;

        /**
         * 字段名
         */
        @ApiModelProperty(name = "field", value = "字段名", required = false)
        private String field;

        /**
         * 提示语
         */
        @ApiModelProperty(name = "tips", value = "提示语", required = false)
        private String tips;

        /**
         * 是否必填，true/false
         */
        @ApiModelProperty(name = "required", value = "是否必填，true/false", required = false)
        private Boolean required;

    }

    @Data
    @Accessors(chain = true)
    @ApiModel("奖品信息")
    public static class PrizeInfo {

        /**
         * 奖项名称
         */
        @ApiModelProperty(name = "prizeItem", value = "奖项名称", required = false)
        private String prizeItem;

        /**
         * 答对题目数
         */
        @ApiModelProperty(name = "correctAnswerCount", value = "答对题目数", required = false)
        private Integer correctAnswerCount;

        /**
         * 奖品名称
         */
        @ApiModelProperty(name = "prizeName", value = "奖品名称", required = false)
        private String prizeName;

        /**
         * 奖品图片
         */
        @ApiModelProperty(name = "thumbnail", value = "奖品图片", required = false)
        private String thumbnail;

        /**
         * 优惠价格
         */
        @ApiModelProperty(name = "realPrice", value = "优惠价格", required = false)
        private BigDecimal realPrice;

        /**
         * 奖品原价
         */
        @ApiModelProperty(name = "price", value = "奖品原价", required = false)
        private BigDecimal price;

        /**
         * 领奖方式，form:表单，link:外链，qrCode:识别二维码
         */
        @ApiModelProperty(name = "acceptType", value = "领奖方式，form:表单，link:外链，qrCode:识别二维码", required = false)
        private String acceptType;

        /**
         * 领奖方式奖品链接
         */
        @ApiModelProperty(name = "prizeUrl", value = "领奖方式奖品链接", required = false)
        private String prizeUrl;

        /**
         * 领奖方式二维码链接
         */
        @ApiModelProperty(name = "qrCode", value = "领奖方式二维码链接", required = false)
        private String qrCode;

        /**
         * 领奖方式二维码提示语
         */
        @ApiModelProperty(name = "qrCodeTips", value = "领奖方式二维码提示语", required = false)
        private String qrCodeTips;

        /**
         * 中奖人数
         */
        @ApiModelProperty(name = "amount", value = "中奖人数", required = false)
        private Integer amount;

        /**
         * 是否隐藏中奖人数
         */
        @ApiModelProperty(name = "hiddenWinnerAmount", value = "是否隐藏中奖人数", required = false)
        private String hiddenWinnerAmount;

        /**
         * 领奖方式表单字段信息
         */
        @ApiModelProperty(name = "formInfo", value = "领奖方式表单字段信息", required = false)
        private List<LiveLotteryActivityResponse.ReceiveInfo> formInfo;

    }

}
