package net.polyv.live.v1.service.interact;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v2.entity.channel.interact.LiveCreateLotteryActivityRequest;
import net.polyv.live.v2.entity.channel.interact.LiveCreateLotteryActivityResponse;
import net.polyv.live.v2.entity.channel.interact.LiveDeleteLotteryActivityRequest;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityListRequest;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityListPageResponse;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityRequest;
import net.polyv.live.v2.entity.channel.interact.LiveLotteryActivityResponse;
import net.polyv.live.v2.entity.channel.interact.LiveUpdateLotteryActivityRequest;

/**
 * 抽奖活动
 * @author: sadboy
 */
public interface ILiveLotteryActivityService {
    
    /**
     * 查询抽奖活动
     * API地址：https://help.polyv.net/#/live/api/v4/channel/lottery_activity/lottery_activity_get
     * @param liveLotteryActivityRequest 查询抽奖活动请求实体
     * @return 查询抽奖活动返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveLotteryActivityResponse getLotteryActivity(LiveLotteryActivityRequest liveLotteryActivityRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 创建抽奖活动
     * API地址：https://help.polyv.net/#/live/api/v4/channel/lottery_activity/lottery_activity_create
     * @param liveCreateLotteryActivityRequest 创建抽奖活动请求实体
     * @return 创建抽奖活动返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveCreateLotteryActivityResponse createLotteryActivity(
            LiveCreateLotteryActivityRequest liveCreateLotteryActivityRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 更新抽奖活动
     * API地址：https://help.polyv.net/#/live/api/v4/channel/lottery_activity/lottery_activity_update
     * @param liveUpdateLotteryActivityRequest 更新抽奖活动请求实体
     * @return 更新抽奖活动返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateLotteryActivity(LiveUpdateLotteryActivityRequest liveUpdateLotteryActivityRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除抽奖活动
     * API地址：https://help.polyv.net/#/live/api/v4/channel/lottery_activity/lottery_activity_delete
     * @param liveDeleteLotteryActivityRequest 删除抽奖活动请求实体
     * @return 删除抽奖活动返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteLotteryActivity(LiveDeleteLotteryActivityRequest liveDeleteLotteryActivityRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询抽奖活动列表
     * API地址：https://help.polyv.net/#/live/api/v4/channel/lottery_activity/lottery_activity_list
     * @param liveLotteryActivityListRequest 查询抽奖活动列表请求实体
     * @return 查询抽奖活动列表返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveLotteryActivityListPageResponse listLotteryActivity(LiveLotteryActivityListRequest liveLotteryActivityListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    
}
