package net.polyv.live.v1.service.interact;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v2.entity.channel.statistics.LiveGetInviteStatsRequest;
import net.polyv.live.v2.entity.channel.statistics.LiveGetInviteStatsResponse;
import net.polyv.live.v2.entity.channel.web.interact.LiveCreateInviterRequest;
import net.polyv.live.v2.entity.channel.web.interact.LiveCreateInviterResponse;

/**
 * 邀请海报
 * @author: jiangyifan
 */
public interface ILiveInvitePosterService {
    
    /**
     * 查询邀请海报明细数据
     * API地址：https://help.polyv.net/#/live/api/v4/channel/statistics/get_invite_stats
     * @param liveGetInviteStatsRequest 查询邀请海报明细数据请求实体
     * @return 查询邀请海报明细数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetInviteStatsResponse getInviteStats(LiveGetInviteStatsRequest liveGetInviteStatsRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 创建邀请者
     * API地址：https://help.polyv.net/#/live/api/v4/channel/interaction/invite/inviter_create
     * @param liveCreateInviterRequest 创建邀请者请求实体
     * @return 创建邀请者响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveCreateInviterResponse createInviter(LiveCreateInviterRequest liveCreateInviterRequest)
            throws IOException, NoSuchAlgorithmException;
}
