package net.polyv.live.v1.service.chat.impl;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.chat.LiveBadWordRequest;
import net.polyv.live.v1.entity.chat.LiveBadWordResponse;
import net.polyv.live.v1.entity.chat.LiveChatBannedIPRequest;
import net.polyv.live.v1.entity.chat.LiveChatDelSingleMsgRequest;
import net.polyv.live.v1.entity.chat.LiveCleanChannelAllMsgRequest;
import net.polyv.live.v1.entity.chat.LiveDelBannedDataRequest;
import net.polyv.live.v1.entity.chat.LiveGetAccountBadWordRequest;
import net.polyv.live.v1.entity.chat.LiveGetBadwordIPRequest;
import net.polyv.live.v1.entity.chat.LiveGetBannedListRequest;
import net.polyv.live.v1.entity.chat.LiveGetChatAdminDataRequest;
import net.polyv.live.v1.entity.chat.LiveGetChatAdminDataResponse;
import net.polyv.live.v1.entity.chat.LiveGetChatUserCountRequest;
import net.polyv.live.v1.entity.chat.LiveGetConsultingRecordRequest;
import net.polyv.live.v1.entity.chat.LiveGetConsultingRecordResponse;
import net.polyv.live.v1.entity.chat.LiveGetHistoryChatMsgRequest;
import net.polyv.live.v1.entity.chat.LiveGetHistoryChatMsgResponse;
import net.polyv.live.v1.entity.chat.LiveGetMessageListRequest;
import net.polyv.live.v1.entity.chat.LiveGetMessageListResponse;
import net.polyv.live.v1.entity.chat.LiveGetQuestionStatisticalRequest;
import net.polyv.live.v1.entity.chat.LiveGetQuestionStatisticalResponse;
import net.polyv.live.v1.entity.chat.LiveKickedListRequest;
import net.polyv.live.v1.entity.chat.LiveKickedListResponse;
import net.polyv.live.v1.entity.chat.LiveSendAdminMessageRequest;
import net.polyv.live.v1.entity.chat.LiveSendAdminMessageResponse;
import net.polyv.live.v1.entity.chat.LiveSendChannelChatRequest;
import net.polyv.live.v1.entity.chat.LiveSendChatMsgRequest;
import net.polyv.live.v1.entity.chat.LiveSendChatMsgResponse;
import net.polyv.live.v1.entity.chat.LiveSendCustomChatRequest;
import net.polyv.live.v1.entity.chat.LiveSetChatAdminDataRequest;
import net.polyv.live.v1.entity.chat.LiveSetTeacherDataRequest;
import net.polyv.live.v1.entity.chat.LiveUpdateChatCensorRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.chat.ILiveChatRoomService;
import net.polyv.live.v2.entity.chat.LiveAlertChatSpecialRequest;
import net.polyv.live.v2.entity.chat.LiveDeleteUserBadwordRequest;
import net.polyv.live.v2.entity.chat.LiveGetRobotSettingRequest;
import net.polyv.live.v2.entity.chat.LiveGetRobotSettingResponse;
import net.polyv.live.v2.entity.chat.LiveGetRobotStatsRequest;
import net.polyv.live.v2.entity.chat.LiveGetRobotStatsResponse;
import net.polyv.live.v2.entity.chat.LiveGetUserBannedListRequest;
import net.polyv.live.v2.entity.chat.LiveGetUserBannedListResponse;
import net.polyv.live.v2.entity.chat.LivePauseRobotRequest;
import net.polyv.live.v2.entity.chat.LiveSendCustomMessageRequest;
import net.polyv.live.v2.entity.chat.LiveUpdateBannedUserRequest;
import net.polyv.live.v2.entity.chat.LiveUpdateRobotSettingRequest;
import net.polyv.live.v2.entity.chat.LiveUpdateUserBannedViewerRequest;

/**
 * 直播签到管理
 * @author: thomas
 **/
@Slf4j
public class LiveChatRoomServiceImpl extends LiveBaseService implements ILiveChatRoomService {
    
    /**
     * 通过HTTP接口发送聊天消息请求实体，API地址：https://dev.polyv.net/2019/liveproduct/zblts/send-admin-msg/
     * @param liveSendChatMsgRequest 查询签到结果请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    @Deprecated
    public LiveSendChatMsgResponse sendChatMsg(LiveSendChatMsgRequest liveSendChatMsgRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_SEND_MSG_URL;
        return super.postFormBodyReturnOne(url, liveSendChatMsgRequest, LiveSendChatMsgResponse.class);
    }
    
    /**
     * 设置讲师信息，API地址：https://dev.polyv.net/2019/liveproduct/zblts/update-channel-teacher/
     * @param liveSetTeacherDataRequest 设置讲师信息请求实体
     * @return 设置成功返回 "true" , 设置失败抛出异常 BussinessExcepiton
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean setChannelTeacherMsg(LiveSetTeacherDataRequest liveSetTeacherDataRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_SET_TEACHER_URL;
        return super.postFormBodyReturnOne(url, liveSetTeacherDataRequest, Boolean.class);
    }
    
    /**
     * 设置聊天室禁言ip，API地址：https://dev.polyv.net/2017/liveproduct/zblts/addbannedip/
     * @param liveChatBannedIPRequest 设置聊天室禁言ip请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<String> addBannedIP(LiveChatBannedIPRequest liveChatBannedIPRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_BANNED_IP_URL, liveChatBannedIPRequest.getChannelId());
        return super.postFormBodyReturnList(url, liveChatBannedIPRequest, String.class);
    }
    
    /**
     * 批量导入频道严禁词，API地址：https://dev.polyv.net/2017/liveproduct/zblts/addforbiddenwords/
     * @param liveBadWordRequest 批量导入频道严禁词请求实体
     * @return 响应实体
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveBadWordResponse addBadWord(LiveBadWordRequest liveBadWordRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_SET_BAD_WORD_URL, LiveGlobalConfig.getUserId());
        return super.postFormBodyReturnOne(url, liveBadWordRequest, LiveBadWordResponse.class);
    }
    
    /**
     * 查询频道禁言列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/get-banned-list/
     * @param liveGetBannedListRequest 查询频道禁言列表请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<String> getBannedList(LiveGetBannedListRequest liveGetBannedListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_GET_CHANNEL_BANNED_LIST_URL;
        return super.getReturnList(url, liveGetBannedListRequest, String.class);
    }
    
    /**
     * 查询频道踢人列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/list-kicked/
     * @param liveKickedListRequest 查询频道踢人列表请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveKickedListResponse> getKickedList(LiveKickedListRequest liveKickedListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_LIST_KICKED_URL;
        return super.postFormBodyReturnList(url, liveKickedListRequest, LiveKickedListResponse.class);
    }
    
    /**
     * 删除禁言IP/严禁词，API地址：https://dev.polyv.net/2017/liveproduct/zblts/delbanned/
     * @param liveDelBannedDataRequest 删除禁言IP/严禁词请求实体
     * @return 当前账号下所有禁言IP列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean delBanned(LiveDelBannedDataRequest liveDelBannedDataRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_DEL_BANNED_URL, liveDelBannedDataRequest.getChannelId());
        super.postFormBodyReturnOne(url, liveDelBannedDataRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询频道严禁词/禁言IP列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/get-channel-badwords/
     * @param liveGetBadwordIPRequest 查询频道严禁词/禁言IP列表请求实体
     * @return 禁言IP 或者 禁言词
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<String> getChannelBadworkList(LiveGetBadwordIPRequest liveGetBadwordIPRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_GET_BAKWORD_WORD_IP_URL;
        return super.postFormBodyReturnList(url, liveGetBadwordIPRequest, String.class);
    }
    
    /**
     * 查询账号严禁词列表，API地址：https://dev.polyv.net/2019/liveproduct/zblts/user-badword-list/
     * @param liveGetAccountBadWordRequest 查询账号严禁词列表请求实体
     * @return 禁言词列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<String> getAccountBadworkList(LiveGetAccountBadWordRequest liveGetAccountBadWordRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_GET_ACCOUNT_BAKWORD_WORD_URL;
        return super.getReturnList(url, liveGetAccountBadWordRequest, String.class);
    }
    
    /**
     * 删除频道聊天记录，API地址：https://dev.polyv.net/2017/liveproduct/zblts/cleanchat/
     * @param liveCleanChannelAllMsgRequest 删除频道聊天记录请求实体
     * @return 频道号
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    @Override
    public Boolean cleanChannelAllMsg(LiveCleanChannelAllMsgRequest liveCleanChannelAllMsgRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_CLEAN_CHANNEL_MSG_URL,
                liveCleanChannelAllMsgRequest.getChannelId());
        return super.getReturnOne(url, liveCleanChannelAllMsgRequest, Boolean.class);
    }
    
    /**
     * 查询聊天室管理员信息，API地址：https://dev.polyv.net/2017/liveproduct/zblts/get-chat-admin/
     * @param liveGetChatAdminDataRequest 查询聊天室管理员信息请求实体
     * @return 频道号
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    @Override
    public LiveGetChatAdminDataResponse getChatAdminData(LiveGetChatAdminDataRequest liveGetChatAdminDataRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_GET_ADMIN_URL, liveGetChatAdminDataRequest.getChannelId());
        return super.postFormBodyReturnOne(url, liveGetChatAdminDataRequest, LiveGetChatAdminDataResponse.class);
    }
    
    /**
     * 查询历史聊天信息，API地址：https://dev.polyv.net/2017/liveproduct/zblts/gethistorymsg/
     * @param liveGetHistoryChatMsgRequest 查询历史聊天信息请求实体
     * @return 想要实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public List<LiveGetHistoryChatMsgResponse> getHistoryChatMsg(
            LiveGetHistoryChatMsgRequest liveGetHistoryChatMsgRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_GET_HISTORY_MSG_URL;
        return super.postFormBodyReturnList(url, liveGetHistoryChatMsgRequest, LiveGetHistoryChatMsgResponse.class);
    }
    
    /**
     * 查询历史聊天信息，API地址：https://help.polyv.net/index.html#/live/api/chat/message/get_message_list
     * @param liveGetMessageListRequest 查询历史聊天信息请求实体
     * @return 想要实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetMessageListResponse getPageHistoryChatMsg(LiveGetMessageListRequest liveGetMessageListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_GET_HISTORY_MSG_PAGE_URL;
        return super.getReturnOne(url, liveGetMessageListRequest, LiveGetMessageListResponse.class);
    }
    
    /**
     * 删除单条聊天记录，API地址：https://dev.polyv.net/2017/liveproduct/zblts/delchat/
     * @param liveChatDelSingleMsgRequest 删除单条聊天记录请求实体
     * @return 是否成功
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    @Override
    public Boolean delChatSingleMsg(LiveChatDelSingleMsgRequest liveChatDelSingleMsgRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_DEL_CHANNEL_SINGLE_MSG_URL,
                liveChatDelSingleMsgRequest.getChannelId());
        super.getReturnOne(url, liveChatDelSingleMsgRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 设置聊天室管理员信息，API地址：https://dev.polyv.net/2017/liveproduct/zblts/set-chat-admin/
     * @param liveSetChatAdminDataRequest 设置聊天室管理员信息请求实体
     * @return 是否成功
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 签名异常
     */
    @Override
    public Boolean setChatAdminData(LiveSetChatAdminDataRequest liveSetChatAdminDataRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_SET_ADMIN_DATA_URL, liveSetChatAdminDataRequest.getChannelId());
        Map<String, File> fileMap = new HashMap<String, File>();
        fileMap.put("avatar", liveSetChatAdminDataRequest.getAvatar());
        super.uploadOneFile(url, liveSetChatAdminDataRequest, fileMap, String.class);
        return Boolean.TRUE;
    }
    
    
    /**
     * 查询咨询提问记录，API地址：https://dev.polyv.net/2018/liveproduct/zblts/getquestion/
     * @param liveGetConsultingRecordRequest 查询咨询提问记录请求实体
     * @return 实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveGetConsultingRecordResponse> getConsultingRecord(
            LiveGetConsultingRecordRequest liveGetConsultingRecordRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_GET_CONSULTING_RECORD_URL,
                liveGetConsultingRecordRequest.getChannelId());
        return super.getReturnList(url, liveGetConsultingRecordRequest, LiveGetConsultingRecordResponse.class);
    }
    
    /**
     * 查询频道的问答统计结果，API地址：https://dev.polyv.net/2018/liveproduct/zblts/get-question-result/
     * @param liveGetQuestionStatisticalRequest 查询频道的问答统计结果请求实体
     * @return 想要实体列表
     * @throws IOException 客户端和服务器读写异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Deprecated
    @Override
    public List<LiveGetQuestionStatisticalResponse> getQuestionStatistical(
            LiveGetQuestionStatisticalRequest liveGetQuestionStatisticalRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.CHAT_GET_QUERSTION_STATISTICAL_URL,
                liveGetQuestionStatisticalRequest.getChannelId());
        return super.postFormBodyReturnList(url, liveGetQuestionStatisticalRequest,
                LiveGetQuestionStatisticalResponse.class);
    }
    
    /**
     * 管理员发送频道聊天信息
     * API地址：https://dev.polyv.net/2018/liveproduct/zblts/chatsendmsg/
     * @param liveSendChannelChatRequest 管理员发送频道聊天信息请求实体
     * @return 管理员发送频道聊天信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean sendChannelChat(LiveSendChannelChatRequest liveSendChannelChatRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.SEND_ADMIN_MSG_URL;
        this.postFormBodyReturnOne(url, liveSendChannelChatRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 发送自定义聊天信息
     * API地址：https://dev.polyv.net/2016/liveproduct/zblts/send-chat/
     * @param liveSendCustomChatRequest 发送自定义聊天信息请求实体
     * @return 发送自定义聊天信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    @Deprecated
    public Boolean sendCustomChat(LiveSendCustomChatRequest liveSendCustomChatRequest)
            throws IOException, NoSuchAlgorithmException {
        liveSendCustomChatRequest.setUserId(LiveGlobalConfig.getUserId());
        String content = liveSendCustomChatRequest.getContent();
        liveSendCustomChatRequest.setContent(content);
        String url = LiveURL.getRealUrl(LiveURL.SEND_CUSTOM_MSG_URL, liveSendCustomChatRequest.getChannelId());
        this.postFormBodyReturnOne(url, liveSendCustomChatRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 发送自定义聊天信息
     * API地址：https://dev.polyv.net/2016/liveproduct/zblts/send-chat/
     * @param liveSendCustomChatRequest 发送自定义聊天信息请求实体
     * @return 发送自定义聊天信息返回实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    @Deprecated
    public Boolean sendCustomChatV2(LiveSendCustomChatRequest liveSendCustomChatRequest)
            throws IOException, NoSuchAlgorithmException {
        liveSendCustomChatRequest.setUserId(LiveGlobalConfig.getUserId());
        String content = liveSendCustomChatRequest.getContent();
        if (StringUtils.isNotEmpty(content)) {
            byte[] data = org.apache.commons.codec.binary.Base64.encodeBase64URLSafe(
                    content.getBytes(StandardCharsets.UTF_8));
            liveSendCustomChatRequest.setContent(new String(data, StandardCharsets.UTF_8));
        }
        String url = LiveURL.getRealUrl(LiveURL.SEND_CUSTOM_MSG_URL, liveSendCustomChatRequest.getChannelId());
        this.postFormBodyReturnOne(url, liveSendCustomChatRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 发送自定义消息，支持是否加入到聊天消息记录
     * API地址：https://help.polyv.net/#/live/api/v4/chat/send_custom_message
     * @param liveSendCustomMessageRequest 发送自定义消息请求实体
     * @return 发送自定义消息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean sendCustomMessage(LiveSendCustomMessageRequest liveSendCustomMessageRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_SEND_CUSTOM_MESSAGE_URL;
        this.getReturnOne(url, liveSendCustomMessageRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 查询频道虚拟人数设置
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/get_robot_setting
     * @param liveGetRobotSettingRequest 查询频道虚拟人数设置请求实体
     * @return 查询频道虚拟人数设置响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetRobotSettingResponse getRobotSetting(LiveGetRobotSettingRequest liveGetRobotSettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_ROBOT_SETTING_URL;
        return this.getReturnOne(url, liveGetRobotSettingRequest, LiveGetRobotSettingResponse.class);
    }
    
    /**
     * 查询频道虚拟人数详情
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/get_robot_stats
     * @param liveGetRobotStatsRequest 查询频道虚拟人数详情请求实体
     * @return 查询频道虚拟人数详情响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetRobotStatsResponse getRobotStats(LiveGetRobotStatsRequest liveGetRobotStatsRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_ROBOT_STATS_URL;
        return this.getReturnOne(url, liveGetRobotStatsRequest, LiveGetRobotStatsResponse.class);
    }
    
    /**
     * 设置频道虚拟人数
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/update_robot_setting
     * @param liveUpdateRobotSettingRequest 设置频道虚拟人数请求实体
     * @return 设置频道虚拟人数响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateRobotSetting(LiveUpdateRobotSettingRequest liveUpdateRobotSettingRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_ROBOT_SETTING_URL;
        this.postEmptyFormBodyReturnOne(url, liveUpdateRobotSettingRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 停止频道虚拟人数
     * API地址：https://help.polyv.net/#/live/api/v4/chat/robot/pause_robot
     * @param livePauseRobotRequest 停止频道虚拟人数请求实体
     * @return 停止频道虚拟人数响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean pauseRobot(LivePauseRobotRequest livePauseRobotRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_PAUSE_ROBOT_URL;
        this.postEmptyFormBodyReturnOne(url, livePauseRobotRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 删除账号严禁词
     * API地址：https://help.polyv.net/#/live/api/chat/banned/delete_user_badword
     * @param liveDeleteUserBadwordRequest 删除账号严禁词请求实体
     * @return 删除账号严禁词响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<String> deleteUserBadword(LiveDeleteUserBadwordRequest liveDeleteUserBadwordRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_DELETE_USER_BADWORD_URL;
        return this.postFormBodyReturnList(url, liveDeleteUserBadwordRequest, String.class);
    }
    
    /**
     * 查询账号禁言列表
     * API地址：https://help.polyv.net/#/live/api/chat/banned/get_user_banned_list
     * @param liveGetUserBannedListRequest 查询账号禁言列表请求实体
     * @return 查询账号禁言列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetUserBannedListResponse getUserBannedList(LiveGetUserBannedListRequest liveGetUserBannedListRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_USER_BANNED_LIST_URL;
        return this.getReturnOne(url, liveGetUserBannedListRequest, LiveGetUserBannedListResponse.class);
    }
    
    /**
     * 禁言/解禁用户
     * API地址：https://help.polyv.net/#/live/api/chat/banned/update_banned_user
     * @param liveUpdateBannedUserRequest 禁言/解禁用户请求实体
     * @return 禁言/解禁用户响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateBannedUser(LiveUpdateBannedUserRequest liveUpdateBannedUserRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_BANNED_USER_URL;
        this.postFormBodyReturnOne(url, liveUpdateBannedUserRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 账号设置禁言/解禁用户
     * API地址：https://help.polyv.net/#/live/api/chat/banned/update_user_banned_viewer
     * @param liveUpdateUserBannedViewerRequest 账号设置禁言/解禁用户请求实体
     * @return 账号设置禁言/解禁用户响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateUserBannedViewer(LiveUpdateUserBannedViewerRequest liveUpdateUserBannedViewerRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_UPDATE_USER_BANNED_VIEWER_URL;
        this.postFormBodyReturnOne(url, liveUpdateUserBannedViewerRequest, String.class);
        return Boolean.TRUE;
    }
    
    /**
     * 管理员发送聊天信息
     * API地址：https://help.polyv.net/index.html#/live/api/chat/message/send_message
     * @param liveSendAdminMessageRequest 管理员发送聊天信息请求实体
     * @return 管理员发送聊天信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveSendAdminMessageResponse sendAdminMessage(LiveSendAdminMessageRequest liveSendAdminMessageRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_SEND_MSG_URL;
        return this.postFormBodyReturnOne(url, liveSendAdminMessageRequest, LiveSendAdminMessageResponse.class);
    }
    
    /**
     * 获取聊天室在线人数
     * API地址：https://help.polyv.net/index.html#/live/api/channel/operate/get_chat_online_count
     * @param liveGetChatUserCountRequest 获取聊天室在线人数请求实体
     * @return 获取聊天室在线人数响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Integer getChatUserCount(LiveGetChatUserCountRequest liveGetChatUserCountRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.CHAT_GET_USER_COUNT_URL;
        return this.getReturnOne(url, liveGetChatUserCountRequest, Integer.class);
    }
    
    /**
     * 更新聊天审核开关
     * API地址：https://help.polyv.net/#/live/api/chat/censor/update_censor_enabled
     * @param liveUpdateChatCensorRequest 更新聊天审核开关请求实体
     * @return 获取聊天室在线人数响应实体响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean updateChatCensorEnabled(LiveUpdateChatCensorRequest liveUpdateChatCensorRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.UPDATE_CHAT_CENSOR_ENABLED_URL;
        return this.postFormBodyReturnOne(url, liveUpdateChatCensorRequest, Boolean.class);
    }
    
    /**
     * 发送开播端弹窗消息
     * API地址：https://help.polyv.net/index.html#/live/api/chat/message/chat_alert_to_special
     * @param liveAlertChatSpecialRequest 发送开播端弹窗消息请求实体
     * @return 发送开播端弹窗消息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public Boolean alertChatSpecial(LiveAlertChatSpecialRequest liveAlertChatSpecialRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.ALERT_CHAT_SPECIAL_URL;
        return this.postFormBodyReturnOne(url, liveAlertChatSpecialRequest, Boolean.class);
    }
    
}
