package net.polyv.live.v1.service.channel.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;

import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.service.LiveResultBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelViewdataResultService;
import net.polyv.live.v2.entity.channel.viewdata.LiveRealviewersRequest;
import net.polyv.live.v2.entity.channel.viewdata.LiveRealviewersResponse;

/**
 * 对接v1返回result属性的接口对象
 * @author: liyongxuan
 */
public class LiveChannelViewdataResultServiceImpl extends LiveResultBaseService
        implements ILiveChannelViewdataResultService {
    
    /**
     * 查询频道实时并发数据
     * API地址：https://help.polyv.net/#/live/api/channel/viewdata/realviewers
     * @param liveRealviewersRequest 查询频道实时并发数据请求实体
     * @return 查询频道实时并发数据响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public List<LiveRealviewersResponse> getRealviewers(LiveRealviewersRequest liveRealviewersRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl(LiveURL.LIVE_GET_REALVIEWERS_URL, liveRealviewersRequest.getChannelId());
        return this.getReturnList(url, liveRealviewersRequest, LiveRealviewersResponse.class);
    }
}
