package net.polyv.live.v1.service.channel;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v1.entity.channel.product.LiveAddProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveAddProductResponse;
import net.polyv.live.v1.entity.channel.product.LiveDeleteChannelProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveGetProductEnabledRequest;
import net.polyv.live.v1.entity.channel.product.LiveGetProductEnabledResponse;
import net.polyv.live.v1.entity.channel.product.LiveGetProductListRequest;
import net.polyv.live.v1.entity.channel.product.LiveGetProductListResponse;
import net.polyv.live.v1.entity.channel.product.LivePushProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveShelfChannelProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveSortChannelProductRequest;
import net.polyv.live.v1.entity.channel.product.LiveUpdateProductEnabledRequest;
import net.polyv.live.v1.entity.channel.product.LiveUpdateProductRequest;

/**
 * 直播商品库接口
 * @author: jiangyifan
 */
public interface LiveChannelProductService {
    
    /**
     * 添加频道商品库商品
     * API地址：https://help.polyv.net/#/live/api/channel/operate/add_channel_product
     * @param liveAddProductRequest 添加频道商品库商品请求实体
     * @return 添加频道商品响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveAddProductResponse addChannelProduct(LiveAddProductRequest liveAddProductRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道商品库开关状态
     * API地址：https://help.polyv.net/#/live/api/channel/operate/get_channel_product_enabled
     * @param liveGetProductEnabledRequest 查询频道商品库开关状态请求实体
     * @return 查询频道商品库开关状态响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetProductEnabledResponse getChannelProductEnabled(LiveGetProductEnabledRequest liveGetProductEnabledRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 查询频道商品列表
     * API地址：https://help.polyv.net/#/live/api/channel/operate/get_channel_product_list
     * @param liveGetProductListRequest 查询频道商品列表请求实体
     * @return 查询频道商品列表响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetProductListResponse getChannelProductList(LiveGetProductListRequest liveGetProductListRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 推送频道商品库商品
     * API地址：https://help.polyv.net/#/live/api/channel/operate/push_channel_product
     * @param livePushProductRequest 推送频道商品库商品请求实体
     * @return 推送频道商品库商品响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean pushChannelProduct(LivePushProductRequest livePushProductRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道商品库开关状态
     * API地址：https://help.polyv.net/#/live/api/channel/operate/update_channel_product_enabled
     * @param liveUpdateProductEnabledRequest 修改频道商品库开关状态请求实体
     * @return 修改频道商品库开关状态响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelProductEnabled(LiveUpdateProductEnabledRequest liveUpdateProductEnabledRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道商品库上下架状态
     * API地址：https://help.polyv.net/#/live/api/channel/operate/shelf_channel_product
     * @param liveShelfChannelProductRequest 修改频道商品库上下架状态请求实体
     * @return 修改频道商品库上下架状态响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean shelfChannelProduct(LiveShelfChannelProductRequest liveShelfChannelProductRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道商品库列表顺序
     * API地址：https://help.polyv.net/#/live/api/channel/operate/sort_channel_product
     * @param liveSortChannelProductRequest 修改频道商品库列表顺序请求实体
     * @return 修改频道商品库列表顺序响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean sortChannelProduct(LiveSortChannelProductRequest liveSortChannelProductRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 删除频道商品
     * API地址：https://help.polyv.net/#/live/api/channel/operate/delete_channel_product
     * @param liveDeleteChannelProductRequest 删除频道商品请求实体
     * @return 删除频道商品响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean deleteChannelProduct(LiveDeleteChannelProductRequest liveDeleteChannelProductRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改频道商品信息
     * API地址：https://help.polyv.net/#/live/api/channel/operate/update_channel_product
     * @param liveUpdateProductRequest 修改频道商品信息请求实体
     * @return 修改频道商品信息响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateChannelProduct(LiveUpdateProductRequest liveUpdateProductRequest)
            throws IOException, NoSuchAlgorithmException;
}
