package net.polyv.live.v1.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 创建并初始化频道返回体
 * @author: sadboy
 **/
@Data
@Accessors(chain = true)
@ApiModel("创建并初始化频道返回体")
public class LiveChannelInitResponse {
    /**
     * 直播频道号
     */
    @ApiModelProperty(name = "channelId", value = "直播频道号", required = false)
    private String channelId;
    
    /**
      *  {@code POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）}
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 直播频道名称
     */
    @ApiModelProperty(name = "name", value = "直播频道名称", required = false)
    private String name;
    
    /**
     * 主持人
     */
    @ApiModelProperty(name = "publisher", value = "主持人", required = false)
    private String publisher;
    
    /**
     * 直播频道描述
     */
    @ApiModelProperty(name = "description", value = "直播频道描述", required = false)
    private String description;
    
    /**
     * 直播推流地址
     */
    @ApiModelProperty(name = "url", value = "直播推流地址", required = false)
    private String url;
    
    /**
     * 直播流名称
     */
    @ApiModelProperty(name = "stream", value = "直播流名称", required = false)
    private String stream;
    
    /**
     * 播放器logo
     */
    @ApiModelProperty(name = "logoImage", value = "播放器logo", required = false)
    private String logoImage;
    
    /**
     * Logo不透明度，1表示完全不透明
     */
    @ApiModelProperty(name = "logoOpacity", value = "Logo不透明度，1表示完全不透明", required = false)
    private Float logoOpacity;
    
    /**
     * Logo位置 tr1：左上，tr：右上，b1：左下，br：右下
     */
    @ApiModelProperty(name = "logoPosition", value = "Logo位置<br/>tr1：左上<br/>tr：右上<br/>b1：左下<br/>br：右下", required = false)
    private String logoPosition;
    
    /**
     * Logo的跳转链接
     */
    @ApiModelProperty(name = "logoHref", value = "Logo的跳转链接", required = false)
    private String logoHref;
    
    /**
     * 播放前显示的封面图
     */
    @ApiModelProperty(name = "coverImage", value = "播放前显示的封面图", required = false)
    private String coverImage;
    
    /**
     * 封面图的跳转链接
     */
    @ApiModelProperty(name = "coverHref", value = "封面图的跳转链接", required = false)
    private String coverHref;
    
    /**
     * 等待推流时的显示图片
     */
    @ApiModelProperty(name = "waitImage", value = "等待推流时的显示图片", required = false)
    private String waitImage;
    
    /**
     * 等待推流时显示图片的跳转链接
     */
    @ApiModelProperty(name = "waitHref", value = "等待推流时显示图片的跳转链接", required = false)
    private String waitHref;
    
    /**
     * 切断流时的显示图片
     */
    @ApiModelProperty(name = "cutoffImage", value = "切断流时的显示图片", required = false)
    private String cutoffImage;
    
    /**
     * 切断流时显示图片的跳转链接
     */
    @ApiModelProperty(name = "cutoffHref", value = "切断流时显示图片的跳转链接", required = false)
    private String cutoffHref;
    
    /**
     * 广告类型
     */
    @ApiModelProperty(name = "advertType", value = "广告类型", required = false)
    private String advertType;
    
    /**
     * 广告时长，单位：秒
     */
    @ApiModelProperty(name = "advertDuration", value = "广告时长，单位：秒", required = false)
    private String advertDuration;
    
    /**
     * 广告区域宽度
     */
    @ApiModelProperty(name = "advertWidth", value = "广告区域宽度", required = false)
    private String advertWidth;
    
    /**
     * 广告区域高度
     */
    @ApiModelProperty(name = "advertHeight", value = "广告区域高度", required = false)
    private String advertHeight;
    
    /**
     * 图片广告
     */
    @ApiModelProperty(name = "advertImage", value = "图片广告", required = false)
    private String advertImage;
    
    /**
     * 广告的跳转链接
     */
    @ApiModelProperty(name = "advertHref", value = "广告的跳转链接", required = false)
    private String advertHref;
    
    /**
     * 视频广告ID
     */
    @ApiModelProperty(name = "advertFlvVid", value = "视频广告ID", required = false)
    private String advertFlvVid;
    
    /**
     * 视频广告链接
     */
    @ApiModelProperty(name = "advertFlvUrl", value = "视频广告链接", required = false)
    private String advertFlvUrl;
    
    /**
     * 播放器控制栏颜色
     */
    @ApiModelProperty(name = "playerColor", value = "播放器控制栏颜色", required = false)
    private String playerColor;
    
    /**
     * 自动播放
     */
    @ApiModelProperty(name = "autoPlay", value = "自动播放", required = false)
    private Boolean autoPlay;
    
    /**
     * 一开始的暖场视频
     */
    @ApiModelProperty(name = "warmUpFlv", value = "一开始的暖场视频", required = false)
    private String warmUpFlv;
    
    /**
     * 观看密码限制，需要输入观看密码才能播放流
     */
    @ApiModelProperty(name = "passwdRestrict", value = "观看密码限制，需要输入观看密码才能播放流", required = false)
    private Boolean passwdRestrict;
    
    /**
     * 观看密码加密后的密文
     */
    @ApiModelProperty(name = "passwdEncrypted", value = "观看密码加密后的密文", required = false)
    private String passwdEncrypted;
    
    /**
     * 仅推音频流 Y：音频模式 N：普通模式
     */
    @ApiModelProperty(name = "isOnlyAudio", value = "仅推音频流：Y：音频模式； N：普通模式；", required = false)
    private String isOnlyAudio;
    
    /**
     * 低延迟，Y-低延迟，N-非低延迟
     */
    @ApiModelProperty(name = "isLowLatency", value = "低延迟，Y-低延迟，N-非低延迟", required = false)
    private String isLowLatency;
    
    /**
     * 直播拉流（播放）m3u8地址
     */
    @ApiModelProperty(name = "m3u8Url", value = "直播拉流（播放）m3u8地址", required = false)
    private String m3u8Url;
    
    /**
     * 直播拉流（播放）m3u8地址1
     */
    @ApiModelProperty(name = "m3u8Url1", value = "直播拉流（播放）m3u8地址1", required = false)
    private String m3u8Url1;
    
    /**
     * 直播拉流（播放）m3u8地址2
     */
    @ApiModelProperty(name = "m3u8Url2", value = "直播拉流（播放）m3u8地址2", required = false)
    private String m3u8Url2;
    
    /**
     * 直播拉流（播放）m3u8地址3
     */
    @ApiModelProperty(name = "m3u8Url3", value = "直播拉流（播放）m3u8地址3", required = false)
    private String m3u8Url3;
    
    /**
     * 频道图标
     */
    @ApiModelProperty(name = "channelLogoImage", value = "频道图标", required = false)
    private String channelLogoImage;
    
    /**
     * 直播场景 alone：活动拍摄 ppt：三分屏 topclass：大班课 seminar：研讨会
     */
    @ApiModelProperty(name = "scene", value = "直播场景 alone：活动拍摄 ppt：三分屏 topclass：大班课 seminar：研讨会", required = false)
    private String scene;
    
    /**
     * 参与者密码
     */
    @ApiModelProperty(name = "channelViewerPasswd", value = "参与者密码", required = false)
    private String channelViewerPasswd;
    
    /**
     * 频道密码
     */
    @ApiModelProperty(name = "channelPasswd", value = "频道密码", required = false)
    private String channelPasswd;
    
    /**
     * 连麦人数 -1：使用账号连麦分数 0-16：代表连麦人数
     */
    @ApiModelProperty(name = "linkMicLimit", value = "连麦人数 -1：使用账号连麦分数 0-16：代表连麦人数", required = false)
    private Integer linkMicLimit;
    
    /**
     * 直播方式 client：客户端推流 pull：拉流 thirdpull：第三方拉流 disk：硬盘推流 audio：音频直播
     */
    @ApiModelProperty(name = "streamType", value = "直播方式 client：客户端推流 pull：拉流 thirdpull：第三方拉流 disk：硬盘推流 audio：音频直播", required = false)
    private String streamType;
    
    /**
     * 是否为无延时直播，默认为N Y：是 N：否
     */
    @ApiModelProperty(name = "pureRtcEnabled", value = "是否为无延时直播，默认为N Y：是 N：否", required = false)
    private String pureRtcEnabled;
    
    /**
     * 频道类型 发起转播：transmit 接收转播：receive 普通频道：normal
     */
    @ApiModelProperty(name = "type", value = "频道类型 发起转播：transmit 接收转播：receive 普通频道：normal", required = false)
    private String type;
    
    /**
     * 中英文直播间开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "cnAndEnLiveEnabled", value = "中英文直播间开关 Y：开启 N：关闭", required = false)
    private String cnAndEnLiveEnabled;
    
    /**
     * 英文推流地址
     */
    @ApiModelProperty(name = "pushEnUrl", value = "英文推流地址", required = false)
    private String pushEnUrl;
    
    /**
     * 服务器返回的时间戳（毫秒）
     */
    @ApiModelProperty(name = "currentTimeMillis", value = "服务器返回的时间戳（毫秒）", required = false)
    private Long currentTimeMillis;
    
}
