package net.polyv.live.v1.entity.channel.operate;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道重制课件配置信息响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道重制课件配置信息响应实体")
public class LiveChannelGetRecordSettingResponse {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = false)
    private String channelId;
    
    /**
     * POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）
     */
    @ApiModelProperty(name = "userId", value = "POLYV用户ID，和保利威官网一致，获取路径：官网->登录->直播（开发设置）", required = false)
    private String userId;
    
    /**
     * 视频布局方式 0：三分屏 1：纯文档 2：画中画
     */
    @ApiModelProperty(name = "type", value = "视频布局方式 0：三分屏 1：纯文档 2：画中画", required = false)
    private Integer type;
    
    /**
     * 是否使用通用设置 Y：是 N：否
     */
    @ApiModelProperty(name = "globalSettingEnabled", value = "是否使用通用设置 Y：是 N：否", required = false)
    private String globalSettingEnabled;
    
    /**
     * 摄像头画面比例 0：画面比例16:9 1：画面比例4:3
     */
    @ApiModelProperty(name = "videoRatio", value = "摄像头画面比例 0：画面比例16:9 1：画面比例4:3", required = false)
    private String videoRatio;
    
    /**
     * 展示图片
     */
    @ApiModelProperty(name = "brandImgFile", value = "展示图片", required = false)
    private String brandImgFile;
    
    /**
     * 背景图片
     */
    @ApiModelProperty(name = "backgroundImgFile", value = "背景图片", required = false)
    private String backgroundImgFile;
    
    /**
     * 重制课件摄像头位置 left：左侧 right：右侧
     */
    @ApiModelProperty(name = "actionPosition", value = "重制课件摄像头位置 left：左侧 right：右侧", required = false)
    private String actionPosition;
    
}