/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.channel.impl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.util.MapUtil;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelDistributeService;
import net.polyv.live.v1.util.LiveSignUtil;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeCreateRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeDeleteRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeListRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeListResponse;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeStatisticRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeStatisticResponse;
import net.polyv.live.v2.entity.channel.distribute.LiveChannelDistributeUpdateRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveDistributeUpdateMasterSwitchRequest;
import net.polyv.live.v2.entity.channel.distribute.LiveDistributeUpdateSwitchRequest;

public class LiveChannelDistributeServiceImpl
extends LiveBaseService
implements ILiveChannelDistributeService {
    @Override
    public LiveChannelDistributeListResponse listChannelDistribute(LiveChannelDistributeListRequest liveChannelDistributeListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/distribute/list";
        return this.getReturnOne(url, liveChannelDistributeListRequest, LiveChannelDistributeListResponse.class);
    }

    @Override
    public Boolean createChannelDistribute(LiveChannelDistributeCreateRequest liveChannelDistributeCreateRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/distribute/create-batch";
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveChannelDistributeCreateRequest);
        signMap.put("channelId", liveChannelDistributeCreateRequest.getChannelId());
        url = MapUtil.appendUrl(url, signMap);
        this.postJsonBodyReturnOne(url, signMap, liveChannelDistributeCreateRequest, JSON.toJSONString(liveChannelDistributeCreateRequest.getContents()), String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateChannelDistribute(LiveChannelDistributeUpdateRequest liveChannelDistributeUpdateRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/distribute/update-batch";
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveChannelDistributeUpdateRequest);
        signMap.put("channelId", liveChannelDistributeUpdateRequest.getChannelId());
        url = MapUtil.appendUrl(url, signMap);
        this.postJsonBodyReturnOne(url, signMap, liveChannelDistributeUpdateRequest, JSON.toJSONString(liveChannelDistributeUpdateRequest.getContents()), String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteChannelDistribute(LiveChannelDistributeDeleteRequest liveChannelDistributeDeleteRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/distribute/delete-batch";
        this.postEmptyFormBodyReturnOne(url, liveChannelDistributeDeleteRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateMasterSwitch(LiveDistributeUpdateMasterSwitchRequest liveDistributeUpdateMasterSwitchRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/distribute/update-master-switch";
        this.postEmptyFormBodyReturnOne(url, liveDistributeUpdateMasterSwitchRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateSwitch(LiveDistributeUpdateSwitchRequest liveDistributeUpdateSwitchRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/distribute/update-switch";
        this.postEmptyFormBodyReturnOne(url, liveDistributeUpdateSwitchRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public List<LiveChannelDistributeStatisticResponse> getDistributeStatistic(LiveChannelDistributeStatisticRequest liveChannelDistributeStatisticRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/distribute/get/statistic";
        return this.getReturnList(url, liveChannelDistributeStatisticRequest, LiveChannelDistributeStatisticResponse.class);
    }
}

