package net.polyv.live.v2.entity.channel.statistics;

import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询频道中奖统计记录响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道中奖统计记录响应实体")
public class LiveGetLotteryListResponse extends LivePageCommonResponse {
    
    /**
     * 中奖记录列表
     */
    @ApiModelProperty(name = "data", value = "中奖记录列表", required = false)
    private List<LiveGetLotteryListResponse.LotteryListContents> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("中奖记录列表【详见data字段说明】")
    public static class LotteryListContents {
        
        /**
         * 实际中奖人数
         */
        @ApiModelProperty(name = "winnerCount", value = "实际中奖人数", required = false)
        private Integer winnerCount;
        
        /**
         * 参与抽奖的人数
         */
        @ApiModelProperty(name = "totalUsers", value = "参与抽奖的人数", required = false)
        private Integer totalUsers;
        
        /**
         * 抽奖ID
         */
        @ApiModelProperty(name = "lotteryId", value = "抽奖场次ID", required = false)
        private String lotteryId;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 账号userId
         */
        @ApiModelProperty(name = "userId", value = "账号userId", required = false)
        private String userId;
        
        /**
         * 抽奖时的直播场次ID
         */
        @ApiModelProperty(name = "sessionId", value = "抽奖时的直播场次ID", required = false)
        private String sessionId;
        
        /**
         * 抽奖候选人范围
         */
        @ApiModelProperty(name = "lotteryRange", value = "抽奖候选人范围", required = false)
        private String lotteryRange;
        
        /**
         * 按头衔抽奖时的头衔名称
         */
        @ApiModelProperty(name = "actor", value = "按头衔抽奖时的头衔名称", required = false)
        private String actor;
        
        /**
         * 奖品名称
         */
        @ApiModelProperty(name = "prize", value = "奖品名称", required = false)
        private String prize;
        
        /**
         * 中奖人数
         */
        @ApiModelProperty(name = "amount", value = "中奖人数", required = false)
        private Integer amount;
        
        /**
         * 预设中奖者，以英文逗号隔开
         */
        @ApiModelProperty(name = "preset", value = "预设中奖者，以英文逗号隔开", required = false)
        private String preset;
        
        /**
         * 抽奖的额外拓展信息
         */
        @ApiModelProperty(name = "lotteryExt", value = "抽奖的额外拓展信息", required = false)
        private LiveGetLotteryListResponse.LotteryListExt lotteryExt;
        
        /**
         * 抽奖时间
         */
        @ApiModelProperty(name = "createdTime", value = "抽奖时间", required = false)
        private Date createdTime;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("抽奖的额外拓展信息")
    public static class LotteryListExt {
        
        /**
         * 中奖用户领奖收集信息列表
         */
        @ApiModelProperty(name = "collectInfo", value = "中奖用户领奖收集信息列表", required = false)
        private List<LotteryListExtCollectInfo> collectInfo;
    }
    
    
    @Data
    @Accessors(chain = true)
    @ApiModel("中奖用户领奖收集信息列表")
    public static class LotteryListExtCollectInfo {
        
        /**
         * 字段名称
         */
        @ApiModelProperty(name = "field", value = "字段名称", required = false)
        private String field;
        
        /**
         * 填写提示
         */
        @ApiModelProperty(name = "tips", value = "填写提示", required = false)
        private String tips;
    }
}