package net.polyv.live.v1.service.channel;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import net.polyv.live.v2.entity.channel.template.LiveGetUserDonateRequest;
import net.polyv.live.v2.entity.channel.template.LiveGetUserDonateResponse;
import net.polyv.live.v2.entity.channel.template.LiveUpdateUserDonateRequest;

/**
 * 默认模板
 * @author: jiangyifan
 */
public interface ILiveChannelTemplateService {
    
    /**
     * 查询直播模板打赏设置
     * API地址：https://help.polyv.net/#/live/api/v4/user/template/getDonate
     * @param liveGetUserDonateRequest 查询直播模板打赏设置请求实体
     * @return 查询直播模板打赏设置(新版)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    LiveGetUserDonateResponse getUserDonate(LiveGetUserDonateRequest liveGetUserDonateRequest)
            throws IOException, NoSuchAlgorithmException;
    
    /**
     * 修改默认模板礼物打赏设置(新版)
     * API地址：https://help.polyv.net/#/live/api/v4/user/template/updateDonate
     * @param liveUpdateUserDonateRequest 修改默认模板礼物打赏设置(新版)请求实体
     * @return 修改默认模板礼物打赏设置(新版)响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    Boolean updateUserDonate(LiveUpdateUserDonateRequest liveUpdateUserDonateRequest)
            throws IOException, NoSuchAlgorithmException;
}
