package net.polyv.live.v1.entity.channel.operate;

import java.io.File;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 设置频道重置课件配置信息请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("设置频道重置课件配置信息请求实体")
public class LiveChannelRecordSettingRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    /**
     * 是否使用通用设置 Y：是 N：否
     */
    @ApiModelProperty(name = "globalSettingEnabled", value = "是否使用通用设置 Y：是 N：否", required = true)
    @NotNull(message = "属性globalSettingEnabled不能为空")
    private String globalSettingEnabled;
    /**
     * 视频布局方式 0：三分屏 1：纯文档 2：画中画
     */
    @ApiModelProperty(name = "type", value = "视频布局方式 0：三分屏 1：纯文档 2：画中画", required = true)
    @NotNull(message = "属性type不能为空")
    private Integer type;
    /**
     * 摄像头画面比例，新版重制有效 0：画面比例16:9 1：画面比例4:3
     */
    @ApiModelProperty(name = "videoRatio", value = "摄像头画面比例，新版重制有效 0：画面比例16:9 1：画面比例4:3", required = false)
    private String videoRatio;
    /**
     * 展示图片，新版重制有效，支持jpg和png格式 摄像头画面比例为16:9时尺寸为480X810 摄像头画面比例为4:3时尺寸为480X720
     */
    @ApiModelProperty(name = "brandImgFile", value = "展示图片，新版重制有效，支持jpg和png格式 摄像头画面比例为16:9时尺寸为480X810 摄像头画面比例为4:3时尺寸为480X720", required = false)
    private File brandImgFile;
    /**
     * 背景图片，旧版重制有效，尺寸为1280X720，支持jpg和png格式
     */
    @ApiModelProperty(name = "backgroundImgFile", value = "背景图片，旧版重制有效，尺寸为1280X720，支持jpg和png格式", required = false)
    private File backgroundImgFile;
}