package net.polyv.live.v2.entity.channel.statistics;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询微信预约数据请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询微信预约数据请求实体")
public class LiveGetBookingStatsRequest extends LivePageNumberCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 预约开始时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "startTime", value = "预约开始时间，13位毫秒级时间戳", required = false)
    private Date startTime;
    
    /**
     * 预约结束时间，13位毫秒级时间戳
     */
    @ApiModelProperty(name = "endTime", value = "预约结束时间，13位毫秒级时间戳", required = false)
    private Date endTime;
    
}