package net.polyv.live.v2.entity.channel.operate.account;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.Length;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改角色信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改角色信息请求实体")
public class LiveUpdateAccountRequest extends LiveCommonRequest {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 助教/嘉宾账号
     */
    @ApiModelProperty(name = "account", value = "助教/嘉宾账号", required = true)
    @NotNull(message = "属性account不能为空")
    private String account;
    
    /**
     * 头衔，助教默认为助教
     */
    @ApiModelProperty(name = "actor", value = "头衔，助教默认为助教", required = false)
    @Length(min = 1, max = 8, message = "头衔长度必须1到8位")
    private String actor;
    
    /**
     * 昵称，默认随机生成昵称
     */
    @ApiModelProperty(name = "nickName", value = "昵称，默认随机生成昵称", required = false)
    @Length(min = 1, max = 8, message = "昵称长度必须1到8位")
    private String nickName;
    
    /**
     * 头像，默认初始头像（JPG、PNG格式图片，需要携带 http:// 或 https://）
     */
    @ApiModelProperty(name = "avatar", value = "头像，默认初始头像（JPG、PNG格式图片，需要携带 http:// 或 https://）", required = false)
    private String avatar;
    
    /**
     * 角色密码
     */
    @ApiModelProperty(name = "passwd", value = "角色密码", required = false)
    @Length(min = 6, max = 16, message = "密码长度必须6到16位")
    private String passwd;
    
    /**
     * 权限
     */
    @ApiModelProperty(name = "purviewList", value = "权限", required = false)
    private List<Purview> purviewList;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("权限列表")
    public static class Purview {
        
        /**
         * 权限 chatListEnabled：在线列表（仅支持助教） pageTurnEnabled：翻页（仅支持助教，且仅能设置一个助教有翻页权限）
         * monitorEnabled：监播（仅支持助教，且仅能设置一个助教有监播权限）
         */
        @ApiModelProperty(name = "code", value =
                "权限 chatListEnabled：在线列表（仅支持助教） pageTurnEnabled：翻页（仅支持助教，且仅能设置一个助教有翻页权限）" +
                        " monitorEnabled：监播（仅支持助教，且仅能设置一个助教有监播权限）", required = true)
        @NotNull(message = "属性code不能为空")
        private String code;
        
        /**
         * 开关 Y：开启 N：关闭
         */
        @ApiModelProperty(name = "enabled", value = "开关 Y：开启 N：关闭", required = true)
        @NotNull(message = "属性enabled不能为空")
        private String enabled;
    }
    
}