package net.polyv.live.v1.service.interact.impl;

import java.io.IOException;
import java.security.NoSuchAlgorithmException;

import lombok.extern.slf4j.Slf4j;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.interact.ILiveRedPackService;
import net.polyv.live.v2.entity.channel.statistics.LiveGetRedPackStatsRequest;
import net.polyv.live.v2.entity.channel.statistics.LiveGetRedPackStatsResponse;

/**
 * 红包管理
 * @author: jiangyifan
 */
@Slf4j
public class ILiveRedPackServiceImpl extends LiveBaseService implements ILiveRedPackService {
    
    /**
     * 查询红包派发数据统计
     * API地址：https://help.polyv.net/#/live/api/channel/statistics/get_redpack_stats
     * @param liveGetRedPackStatsRequest 查询红包派发数据统计请求实体
     * @return 查询红包派发数据统计响应实体
     * @throws IOException 异常
     * @throws NoSuchAlgorithmException 异常
     */
    @Override
    public LiveGetRedPackStatsResponse getRedPackStats(LiveGetRedPackStatsRequest liveGetRedPackStatsRequest)
            throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.LIVE_GET_RED_PACK_STATS_URL;
        return this.getReturnOne(url, liveGetRedPackStatsRequest, LiveGetRedPackStatsResponse.class);
    }
}
