package net.polyv.live.v1.entity.player;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 查询频道防录屏信息请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道防录屏信息请求实体")
public class LiveGetAntiRecordRequest extends LiveCommonRequest {
    /**
     * 频道号 传入频道号，查询频道防录屏信息 不传频道号，查询账号防录屏默认模板
     */
    @ApiModelProperty(name = "channelId", value = "频道号 传入频道号，查询频道防录屏信息 不传频道号，查询账号防录屏默认模板", required = false)
    private String channelId;
    
}