package net.polyv.live.v1.entity.channel.viewdata;

import java.util.Date;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LivePageCommonRequest;

/**
 * 分页查询账号直播观看详情数据请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("分页查询账号直播观看详情数据请求实体")
public class LiveGetChannelViewLogRequest extends LivePageCommonRequest {
    
    /**
     * 查询开始时间，格式:yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty(name = "startDate", value = "查询开始时间，格式:yyyy-MM-dd HH:mm:ss", required = true)
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "属性startDate不能为空")
    private Date startDate;
    
    /**
     * 查询结束时间，格式:yyyy-MM-dd HH:mm:ss
     */
    @ApiModelProperty(name = "endDate", value = "查询结束时间，格式:yyyy-MM-dd HH:mm:ss", required = true)
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    @NotNull(message = "属性endDate不能为空")
    private Date endDate;
    
    /**
     * 频道ID，不传查询所有频道
     */
    @ApiModelProperty(name = "channelId", value = "频道ID，不传查询所有频道", required = false)
    private String channelId;
    
    /**
     * 观看类型， live：直播， vod：回放
     */
    @ApiModelProperty(name = "watchType", value = "观看类型， live：直播， vod：回放", required = false)
    private String watchType;
    
}
