package net.polyv.live.v2.entity.channel.distribute;

import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询云分发数据信息响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询云分发数据信息响应实体")
public class LiveChannelDistributeStatisticResponse {
    
    /**
     * 频道ID
     */
    @ApiModelProperty(name = "channelId", value = "频道ID", required = false)
    private String channelId;
    
    /**
     * 场次号
     */
    @ApiModelProperty(name = "sessionId", value = "场次号", required = false)
    private String sessionId;
    
    /**
     * 直播开始时间
     */
    @ApiModelProperty(name = "liveStartTime", value = "直播开始时间", required = false)
    private Date liveStartTime;
    
    /**
     * 直播结束时间
     */
    @ApiModelProperty(name = "liveEndTime", value = "直播结束时间", required = false)
    private Date liveEndTime;
    
    /**
     * 云分发推流地址
     */
    @ApiModelProperty(name = "distributeUrl", value = "云分发推流地址", required = false)
    private String distributeUrl;
    
    /**
     * 推流开始时间
     */
    @ApiModelProperty(name = "distributeStartTime", value = "推流开始时间", required = false)
    private Date distributeStartTime;
    
    /**
     * 推流结束时间
     */
    @ApiModelProperty(name = "distributeEndTime", value = "推流结束时间", required = false)
    private Date distributeEndTime;
    
    /**
     * 云分发持续时间，单位：秒
     */
    @ApiModelProperty(name = "duration", value = "云分发持续时间，单位：秒", required = false)
    private Integer duration;
    
    /**
     * 错误描述，与 error.code 对应
     */
    @ApiModelProperty(name = "desc", value = "错误描述，与 error.code 对应", required = false)
    private String desc;
    
}