package net.polyv.live.v2.entity.channel.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询所有频道的缩略信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询所有频道的缩略信息请求实体")
public class LiveListAccountChannelSimpleV2Request extends LivePageNumberCommonRequest {
    
    /**
     * 所属分类id
     */
    @ApiModelProperty(name = "categoryId", value = "所属分类id", required = false)
    private Integer categoryId;
    
    /**
     * 观看页状态筛选，live-直播中，playback-回放中，end-已结束，waiting-等待中，unStart-未开始
     */
    @ApiModelProperty(name = "watchStatus", value = "观看页状态筛选，live-直播中，playback-回放中，end-已结束，waiting-等待中，unStart-未开始",
            required = false)
    private String watchStatus;
    
    /**
     * 频道名称，模糊查询
     */
    @ApiModelProperty(name = "keyword", value = "频道名称，模糊查询", required = false)
    private String keyword;
    
}
