package net.polyv.live.v2.entity.channel.account;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageNumberCommonRequest;

/**
 * 查询所有频道的基础信息请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询所有频道的基础信息请求实体")
public class LiveListAccountBasicInfoV2Request extends LivePageNumberCommonRequest {
    
    /**
     * 分类ID，多个id用英文逗号分隔
     */
    @ApiModelProperty(name = "categoryIds", value = "分类ID，多个id用英文逗号分隔", required = false)
    private String categoryIds;
    
}