package net.polyv.live.v1.entity.channel.product;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道商品库上下架状态请求实体
 * @author: jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道商品库上下架状态请求实体")
public class LiveShelfChannelProductRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "productId", value = "商品ID", required = true)
    @NotNull(message = "属性productId不能为空")
    private Integer productId;
    
    /**
     * 商品上下架状态，1：上架，2：下架
     */
    @ApiModelProperty(name = "shelf", value = "商品上下架状态，1：上架，2：下架", required = true)
    @NotNull(message = "属性shelf不能为空")
    private Integer shelf;
}
