package net.polyv.live.v2.entity.channel.web.interact.share;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道微信分享信息请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道微信分享信息请求实体")
public class LiveUpdateChannelShareRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 是否开启分享，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "shareBtnEnable", value = "是否开启分享，Y：开启，N：关闭", required = true)
    @NotNull(message = "属性shareBtnEnable不能为空")
    private String shareBtnEnable;
    
    /**
     * 标题类型follow直播标题、custom自定义
     */
    @ApiModelProperty(name = "titleType", value = "标题类型follow直播标题、custom自定义", required = true)
    @NotNull(message = "属性titleType不能为空")
    private String titleType;
    
    /**
     * 分享标题，最大长度50，标题类型为custom时，该字段必填
     */
    @ApiModelProperty(name = "weixinShareTitle", value = "分享标题，最大长度50，标题类型为custom时，该字段必填", required = false)
    private String weixinShareTitle;
    
    /**
     * 分享简介，最大长度120，标题类型为custom时，该字段必填
     */
    @ApiModelProperty(name = "weixinShareDesc", value = "分享简介，最大长度120，标题类型为custom时，该字段必填", required = false)
    private String weixinShareDesc;
    
    /**
     * 微信自定义分享地址，最大长度512，链接必须带协议，如：https://，链接需要进行encode
     */
    @ApiModelProperty(name = "weixinShareCustomUrl", value = "微信自定义分享地址，最大长度512，链接必须带协议，如：https://，链接需要进行encode",
            required = false)
    private String weixinShareCustomUrl;
    
    /**
     * 网页观看自定义分享地址，最大长度512，链接必须带协议，如：https://，链接需要进行encode
     */
    @ApiModelProperty(name = "webShareCustomUrl", value = "网页观看自定义分享地址，最大长度512，链接必须带协议，如：https://，链接需要进行encode",
            required = false)
    private String webShareCustomUrl;
    
}