package net.polyv.live.v2.entity.channel.web.interact;

import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询频道打赏设置(新版)响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询频道打赏设置响应实体")
public class LiveGetChannelDonateResponse {
    
    /**
     * 现金红包打赏开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "donateCashEnabled", value = "现金红包打赏开关，Y：开启，N：关闭", required = false)
    private String donateCashEnabled;
    
    /**
     * 现金红包
     */
    @ApiModelProperty(name = "cashDonate", value = "现金红包【详见ChannelCashDonate字段说明】", required = false)
    private LiveGetChannelDonateResponse.ChannelCashDonate cashDonate;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("现金红包")
    public static class ChannelCashDonate {
        
        /**
         * 固定打赏金额，数组长度在1-6，最小值0.01，最大值9999.99
         */
        @ApiModelProperty(name = "cashes", value = "固定打赏金额，数组长度在1-6，最小值0.01，最大值9999.99", required = false)
        @JSONField(name = "cashs")
        private List<Float> cashes;
        
        /**
         * 自定义打赏金额-最低金额，最小值0.01，最大值9999.99
         */
        @ApiModelProperty(name = "cashMin", value = "自定义打赏金额-最低金额，最小值0.01，最大值9999.99", required = false)
        private Float cashMin;
    }
    
    /**
     * 礼物打赏开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "donateGiftEnabled", value = "礼物打赏开关，Y：开启，N：关闭", required = false)
    private String donateGiftEnabled;
    
    /**
     * 礼物打赏（现金支付或积分支付）
     */
    @ApiModelProperty(name = "giftDonate", value = "礼物打赏（现金支付或积分支付）【详见ChannelGiftDonate字段说明】", required = false)
    private List<LiveGetChannelDonateResponse.ChannelGiftDonate> giftDonate;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("礼物打赏（现金支付或积分支付）")
    public static class ChannelGiftDonate {
        /**
         * 支付方式，CASH：现金支付，POINT：积分支付
         */
        @ApiModelProperty(name = "payWay", value = "支付方式，CASH：现金支付，POINT：积分支付", required = false)
        private String payWay;
        
        /**
         * 现金单位
         */
        @ApiModelProperty(name = "cashUnit", value = "现金单位", required = false)
        private String cashUnit;
        
        /**
         * 积分单位
         */
        @ApiModelProperty(name = "pointUnit", value = "积分单位", required = false)
        private String pointUnit;
        
        /**
         * 现金支付列表
         */
        @ApiModelProperty(name = "cashPays", value = "现金支付列表【详见ChannelGift字段说明】", required = false)
        private List<LiveGetChannelDonateResponse.ChannelGift> cashPays;
        
        /**
         * 积分支付列表
         */
        @ApiModelProperty(name = "pointPays", value = "积分支付列表【详见ChannelGift字段说明】", required = false)
        private List<LiveGetChannelDonateResponse.ChannelGift> pointPays;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("现金支付列表【详见GiftDonate字段说明】")
    public static class ChannelGift {
        
        /**
         * 礼物名称
         */
        @ApiModelProperty(name = "name", value = "礼物名称", required = false)
        private String name;
        
        /**
         * 礼物图片地址
         */
        @ApiModelProperty(name = "img", value = "礼物图片地址", required = false)
        private String img;
        
        /**
         * 礼物价格
         */
        @ApiModelProperty(name = "price", value = "礼物价格", required = false)
        private Float price;
        
        /**
         * 开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "enabled", value = "开关，Y：开启，N：关闭", required = false)
        private String enabled;
    }
}