package net.polyv.live.v2.entity.channel.template;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改默认模板礼物打赏设置请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改默认模板礼物打赏设置请求实体")
public class LiveUpdateUserDonateRequest extends LiveCommonRequest {
    /**
     * 礼物打赏开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "donateGiftEnabled", value = "礼物打赏开关，Y：开启，N：关闭", required = false)
    private String donateGiftEnabled;
    
    /**
     * 礼物打赏（现金支付或积分支付）
     */
    @ApiModelProperty(name = "giftDonate", value = "礼物打赏（现金支付或积分支付）【详见UserGiftDonate字段说明】", required = false)
    private LiveUpdateUserDonateRequest.UserGiftDonate giftDonate;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("礼物打赏（现金支付或积分支付）")
    public static class UserGiftDonate {
        /**
         * 支付方式，CASH：现金支付，POINT：积分支付
         */
        @ApiModelProperty(name = "payWay", value = "支付方式，CASH：现金支付，POINT：积分支付", required = false)
        private String payWay;
        
        /**
         * 现金单位
         */
        @ApiModelProperty(name = "cashUnit", value = "现金单位", required = false)
        private String cashUnit;
        
        /**
         * 积分单位
         */
        @ApiModelProperty(name = "pointUnit", value = "积分单位", required = false)
        private String pointUnit;
        
        /**
         * 现金支付列表
         */
        @ApiModelProperty(name = "cashPays", value = "现金支付列表【详见UserGift字段说明】", required = false)
        private List<LiveUpdateUserDonateRequest.UserGift> cashPays;
        
        /**
         * 积分支付列表
         */
        @ApiModelProperty(name = "pointPays", value = "积分支付列表【详见UserGift字段说明】", required = false)
        private List<LiveUpdateUserDonateRequest.UserGift> pointPays;
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("礼物列表")
    public static class UserGift {
        
        /**
         * 礼物名称
         */
        @ApiModelProperty(name = "name", value = "礼物名称", required = false)
        private String name;
        
        /**
         * 礼物图片地址
         */
        @ApiModelProperty(name = "img", value = "礼物图片地址", required = false)
        private String img;
        
        /**
         * 礼物价格
         */
        @ApiModelProperty(name = "price", value = "礼物价格", required = false)
        private Float price;
        
        /**
         * 开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "enabled", value = "开关，Y：开启，N：关闭", required = false)
        private String enabled;
    }
    
}