package net.polyv.live.v2.entity.channel.operate;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotBlank;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道装修设置(新版)请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道装修设置请求实体")
public class LiveUpdateChannelDecorateRequest extends LiveCommonRequest {
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 皮肤，black：时尚黑，red：喜庆红，blue：科技蓝，white：经典白，green：薄荷绿，golden：富贵金
     */
    @ApiModelProperty(name = "skin", value = "皮肤，black：时尚黑，red：喜庆红，blue：科技蓝，white：经典白，green：薄荷绿，golden：富贵金",
            required = false)
    private String skin;
    
    /**
     * 普通直播观看页布局配置(普通:normal,竖屏:portrait)
     */
    @ApiModelProperty(name = "aloneWatchLayout", value = "普通直播观看页布局配置(普通:normal,竖屏:portrait)", required = false)
    private String aloneWatchLayout;
    
    /**
     * 装修里聊天对象
     */
    @ApiModelProperty(name = "chat", value = "装修里聊天对象【详见DecorateChat字段说明】", required = false)
    private LiveUpdateChannelDecorateRequest.DecorateChat chat;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("装修里聊天对象")
    public static class DecorateChat {
        /**
         * 累计点赞人数 (点赞基数)
         */
        @ApiModelProperty(name = "baseLikes", value = "累计点赞人数 (点赞基数)", required = false)
        private Integer baseLikes;
        
        /**
         * 在线人数开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "chatOnlineNumberEnable", value = "在线人数开关，Y：开启，N：关闭", required = false)
        private String chatOnlineNumberEnable;
        
        /**
         * 情绪直播间开关，情绪开关和点赞开关同时只能开启一个，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "emotionEnabled", value = "情绪直播间开关，情绪开关和点赞开关同时只能开启一个，Y：开启，N：关闭", required = false)
        private String emotionEnabled;
        
        /**
         * 红包开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "redPackEnabled", value = "红包开关，Y：开启，N：关闭", required = false)
        private String redPackEnabled;
        
        /**
         * 点赞开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "sendFlowersEnabled", value = "点赞开关，Y：开启，N：关闭", required = false)
        private String sendFlowersEnabled;
        
        /**
         * 发送图片开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "viewerSendImgEnabled", value = "发送图片开关，Y：开启，N：关闭", required = false)
        private String viewerSendImgEnabled;
        
        /**
         * 欢迎语开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "welcomeEnabled", value = "欢迎语开关，Y：开启，N：关闭", required = false)
        private String welcomeEnabled;
        
        /**
         * 提现开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "withdrawEnabled", value = "提现开关，Y：开启，N：关闭", required = false)
        private String withdrawEnabled;
    }
    
    /**
     * 装修中文直播介绍页对象
     */
    @ApiModelProperty(name = "desc", value = "装修中文直播介绍页对象【详见DecorateDesc字段说明】", required = false)
    private LiveUpdateChannelDecorateRequest.DecorateDesc desc;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("装修中文直播介绍页对象")
    public static class DecorateDesc {
        /**
         * 暖场图片 -> 封面图片
         */
        @ApiModelProperty(name = "coverImageUrl", value = "暖场图片 -> 封面图片", required = false)
        private String coverImageUrl;
        
        /**
         * 图标URL
         */
        @ApiModelProperty(name = "iconUrl", value = "图标URL", required = false)
        private String iconUrl;
        
        /**
         * 主持人名称，最大长度50
         */
        @ApiModelProperty(name = "publisher", value = "主持人名称，最大长度50", required = false)
        private String publisher;
        
        /**
         * 标题 -> 直播名称，最大长度100
         */
        @ApiModelProperty(name = "title", value = "标题 -> 直播名称，最大长度100", required = false)
        private String title;
    }
    
    /**
     * 中文菜单列表对象
     */
    @ApiModelProperty(name = "menus", value = "中文菜单列表对象【详见DecorateMenus字段说明】", required = false)
    private List<LiveUpdateChannelDecorateRequest.DecorateMenus> menus;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("中文菜单列表对象")
    public static class DecorateMenus {
        /**
         * 菜单内容
         */
        @ApiModelProperty(name = "content", value = "菜单内容", required = false)
        private String content;
        
        /**
         * 菜单ID
         */
        @ApiModelProperty(name = "menuId", value = "菜单ID", required = false)
        private String menuId;
        
        /**
         * 菜单名称
         */
        @ApiModelProperty(name = "name", value = "菜单名称", required = true)
        @NotBlank(message = "属性name不能为空")
        private String name;
        
        /**
         * 菜单类型 desc：直播介绍 chat：互动聊天 quiz：提问 qa：问答 invite：邀请海报 text：图文菜单
         */
        @ApiModelProperty(name = "type", value = "菜单类型 desc：直播介绍 chat：互动聊天 quiz：提问 qa：问答 invite：邀请海报 text：图文菜单",
                required = true)
        @NotBlank(message = "属性type不能为空")
        private String type;
    }
    
    /**
     * 装修播放器对象
     */
    @ApiModelProperty(name = "player", value = "装修播放器对象【详见DecoratePlayer字段说明】", required = false)
    private LiveUpdateChannelDecorateRequest.DecoratePlayer player;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("装修播放器对象")
    public static class DecoratePlayer {
        /**
         * 实际累计观看次数 (真实次数)
         */
        @ApiModelProperty(name = "actualPV", value = "实际累计观看次数 (真实次数)", required = false)
        private Integer actualPV;
        
        /**
         * PC背景图片
         */
        @ApiModelProperty(name = "backgroundUrl", value = "PC背景图片", required = false)
        private String backgroundUrl;
        
        /**
         * 基础观看次数
         */
        @ApiModelProperty(name = "basePV", value = "基础观看次数", required = false)
        private Integer basePV;
        
        /**
         * 封面(暖场)跳转链接
         */
        @ApiModelProperty(name = "coverJumpUrl", value = "封面(暖场)跳转链接", required = false)
        private String coverJumpUrl;
        
        /**
         * 水印链接
         */
        @ApiModelProperty(name = "iconLink", value = "水印链接", required = false)
        private String iconLink;
        
        /**
         * 图标位置 (水印位置)
         */
        @ApiModelProperty(name = "iconPosition", value = "图标位置 (水印位置)", required = false)
        private String iconPosition;
        
        /**
         * 水印图片URL
         */
        @ApiModelProperty(name = "iconUrl", value = "水印图片URL", required = false)
        private String iconUrl;
        
        /**
         * 水印不透明度，0：完全透明，1：完全不透明
         */
        @ApiModelProperty(name = "logoOpacity", value = "水印不透明度，0：完全透明，1：完全不透明", required = false)
        private Float logoOpacity;
        
        /**
         * 暖场开关，Y：开启，N：关闭
         */
        @ApiModelProperty(name = "warmUpEnabled", value = "暖场开关，Y：开启，N：关闭", required = false)
        private String warmUpEnabled;
        
        /**
         * 暖场图片地址 (直播封面图)
         */
        @ApiModelProperty(name = "warmUpImageUrl", value = "暖场图片地址 (直播封面图)", required = false)
        private String warmUpImageUrl;
        
        /**
         * 水印开关,Y：开启，N：关闭
         */
        @ApiModelProperty(name = "watermarkEnabled", value = "水印开关,Y：开启，N：关闭", required = false)
        private String watermarkEnabled;
    }
    
    /**
     * 三分屏移动端观看布局,normal:常规直播,portrait:直播带货
     */
    @ApiModelProperty(name = "pptMobileWatchLayout", value = "三分屏移动端观看布局,normal:常规直播,portrait:直播带货", required = false)
    private String pptMobileWatchLayout;
    
    /**
     * 装修引导页对象
     */
    @ApiModelProperty(name = "splash", value = "装修引导页对象【详见DecorateSplash字段说明】", required = false)
    private LiveUpdateChannelDecorateRequest.DecorateSplash splash;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("装修引导页对象")
    public static class DecorateSplash {
        /**
         * 引导页图片
         */
        @ApiModelProperty(name = "splashImageUrl", value = "引导页图片", required = false)
        private String splashImageUrl;
    }
    
    /**
     * 引导页开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "splashEnabled", value = "引导页开关，Y：开启，N：关闭", required = false)
    private String splashEnabled;
    
    /**
     * 双语直播间开关，Y：开启，N：关闭
     */
    @ApiModelProperty(name = "englishSettingEnabled", value = "双语直播间开关，Y：开启，N：关闭", required = false)
    private String englishSettingEnabled;
    
    /**
     * 英文菜单列表对象
     */
    @ApiModelProperty(name = "enMenus", value = "英文菜单列表对象【详见DecorateMenus字段说明】", required = false)
    private List<LiveUpdateChannelDecorateRequest.DecorateMenus> enMenus;
    
    /**
     * 模板-装修英文直播介绍页对象
     */
    @ApiModelProperty(name = "descEn", value = "模板-装修英文直播介绍页对象【详见DecorateDescEn字段说明】", required = false)
    private LiveUpdateChannelDecorateRequest.DecorateDescEn descEn;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("模板-装修英文直播介绍页对象")
    public static class DecorateDescEn {
        /**
         * 主持人英文名称，最大长度50
         */
        @ApiModelProperty(name = "publisher", value = "主持人英文名称，最大长度50", required = false)
        private String publisher;
        
        /**
         * 直播英文名称，最大长度100
         */
        @ApiModelProperty(name = "title", value = "直播英文名称，最大长度100", required = false)
        private String title;
    }
}