package net.polyv.live.v2.entity.channel.distribute;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量修改分分发地址请求实体
 * @author jiangyifan
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量修改分分发地址请求实体")
public class LiveChannelDistributeUpdateRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 分发地址请求列表【详见contents字段说明】
     */
    @ApiModelProperty(name = "result", value = "分发地址请求对象列表【详见contents字段说明】", required = true)
    @NotNull(message = "属性contents不能为空")
    private List<LiveChannelDistributeUpdateRequest.UpdateDistribute> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("分发地址请求对象列表【详见contents字段说明】")
    public static class UpdateDistribute {
        
        /**
         * 云分发ID
         */
        @ApiModelProperty(name = "id", value = "云分发ID", required = true)
        @NotNull(message = "属性id不能为空")
        private Integer id;
        
        /**
         * 分发地址名称，长度不能超过20
         */
        @ApiModelProperty(name = "name", value = "分发地址名称，长度不能超过20", required = false)
        private String name;
        
        /**
         * 推流地址，例：rtmp://polyv.net，需满足正则：(^([rR][tT][mM][pP]://)([\w-]+.)+[\w-]+(/[\w-./?%#&=]*)?$)
         */
        @ApiModelProperty(name = "distributeUrl", value = "推流地址，例：rtmp://polyv.net，需满足正则：(^([rR][tT][mM][pP]://)" +
                "([\\w-]+.)+[\\w-]+(/[\\w-./?%#&=]*)?$)", required = false)
        private String distributeUrl;
        
        /**
         * 直播码
         */
        @ApiModelProperty(name = "distributeLiveCode", value = "直播码", required = false)
        private String distributeLiveCode;
    }
}