package net.polyv.live.v2.entity.channel.distribute;

import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 查询分发地址信息响应实体
 * @author jiangyifan
 */
@Data
@Accessors(chain = true)
@ApiModel("查询分发地址信息响应实体")
public class LiveChannelDistributeListResponse {
    
    /**
     * 频道分发直播总开关 Y：开启 N：关闭
     */
    @ApiModelProperty(name = "distributeEnable", value = "频道分发直播总开关 Y：开启 N：关闭", required = false)
    private String distributeEnable;
    
    /**
     * 分发地址响应对象列表【详见result字段说明】
     */
    @ApiModelProperty(name = "result", value = "分发地址响应对象列表【详见result字段说明】", required = false)
    private List<LiveChannelDistributeListResponse.ChannelDistribute> result;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("分发地址响应对象列表【详见result字段说明】")
    public static class ChannelDistribute {
        
        /**
         * 云分发ID
         */
        @ApiModelProperty(name = "id", value = "云分发ID", required = false)
        private Integer id;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 分发地址名称
         */
        @ApiModelProperty(name = "name", value = "分发地址名称", required = false)
        private String name;
        
        /**
         * 推流地址
         */
        @ApiModelProperty(name = "distributeUrl", value = "推流地址", required = false)
        private String distributeUrl;
        
        /**
         * 直播码
         */
        @ApiModelProperty(name = "distributeLiveCode", value = "直播码", required = false)
        private String distributeLiveCode;
        
        /**
         * 分发直播开关 Y：打开 N：关闭
         */
        @ApiModelProperty(name = "status", value = "分发直播开关 Y：打开 N：关闭", required = false)
        private String status;
        
        /**
         * 连接状态 completed：已结束 processing：转推中 waiting：等待连接中 error：转推失败
         */
        @ApiModelProperty(name = "connectionStatus", value = "连接状态 completed：已结束 processing：转推中 waiting：等待连接中 " +
                "error：转推失败", required = false)
        private String connectionStatus;
    }
}