package net.polyv.live.v1.entity.channel.product;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道商品信息请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道商品信息请求实体")
public class LiveUpdateProductRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 商品库商品productId
     */
    @ApiModelProperty(name = "productId", value = "商品库商品productId", required = true)
    @NotNull(message = "属性productId不能为空")
    private Integer productId;
    
    /**
     * 商品名称，必填，长度范围：1-60
     */
    @ApiModelProperty(name = "name", value = "商品名称，必填，长度范围：1-60", required = true)
    @NotNull(message = "属性name不能为空")
    private String name;
    
    /**
     * 商品实际价格，保留两位小数，如：0.01
     */
    @ApiModelProperty(name = "realPrice", value = "商品实际价格，保留两位小数，如：0.01", required = true)
    @NotNull(message = "属性realPrice不能为空")
    private Float realPrice;
    
    /**
     * 商品链接类型 10：通用链接 11：多平台链接
     */
    @ApiModelProperty(name = "linkType", value = "商品链接类型 10：通用链接 11：多平台链接", required = true)
    @NotNull(message = "属性linkType不能为空")
    private Integer linkType;
    
    /**
     * 商品封面链接，必填，长度范围：1-500
     */
    @ApiModelProperty(name = "cover", value = "商品封面链接，必填，长度范围：1-500", required = true)
    @NotNull(message = "属性cover不能为空")
    private String cover;
    
    /**
     * 商品价格，保留两位小数，如：0.01
     */
    @ApiModelProperty(name = "price", value = "商品价格，保留两位小数，如：0.01", required = false)
    private Float price;
    
    /**
     * 通用链接，商品链接，长度1-500，当linkType=10时，该参数必填；当请求参数linkType=11时，该参数无效
     */
    @ApiModelProperty(name = "link", value = "通用链接，商品链接，长度1-500，当linkType=10时，该参数必填；当请求参数linkType=11时，该参数无效",
            required = false)
    private String link;
    
    /**
     * 多平台链接，pc端跳转链接，长度1-500 当请求参数linkType=11时，该参数必填；当请求参数linkType=10时，该参数无效
     */
    @ApiModelProperty(name = "pcLink", value = "多平台链接，pc端跳转链接，长度1-500 当请求参数linkType=11时，该参数必填；当请求参数linkType=10" +
            "时，该参数无效", required = false)
    private String pcLink;
    
    /**
     * 多平台链接，移动web端链接
     */
    @ApiModelProperty(name = "mobileLink", value = "多平台链接，移动web端链接", required = false)
    private String mobileLink;
    
    /**
     * 多平台链接，小程序内页面路径及参数（对于path属性，所声明的页面路径必须添加.html后缀，如pages/home/index.html）
     */
    @ApiModelProperty(name = "wxMiniProgramLink", value = "多平台链接，小程序内页面路径及参数（对于path属性，所声明的页面路径必须添加" +
            ".html后缀，如pages/home/index.html）", required = false)
    @JSONField(name = "wxMiniprogramLink")
    private String wxMiniProgramLink;
    
    /**
     * 多平台链接，小程序端原始Id
     */
    @ApiModelProperty(name = "wxMiniProgramOriginalId", value = "多平台链接，小程序端原始Id", required = false)
    @JSONField(name = "wxMiniprogramOriginalId")
    private String wxMiniProgramOriginalId;
    
    /**
     * 多平台链接，移动App端链接
     */
    @ApiModelProperty(name = "mobileAppLink", value = "多平台链接，移动App端链接", required = false)
    private String mobileAppLink;
    
    /**
     * 自定义参数，类型json对象，需要转为string
     */
    @ApiModelProperty(name = "params", value = "自定义参数，类型json对象，需要转为string", required = false)
    private String params;
    
    /**
     * 产品描述
     */
    @ApiModelProperty(name = "productDesc", value = "产品描述", required = false)
    private String productDesc;
    
    /**
     * 产品特色，卖点标签，可以多个，json字段，如：["tab1", "tab2"]
     */
    @ApiModelProperty(name = "features", value = "产品特色，卖点标签，可以多个，json字段，如：[\"tab1\", \"tab2\"]", required = false)
    private String features;
    
    /**
     * 金融商品参数，按钮显示文案
     */
    @ApiModelProperty(name = "btnShow", value = "金融商品参数，按钮显示文案", required = false)
    private String btnShow;
    
    /**
     * 金融商品参数，产品收益率/价格
     */
    @ApiModelProperty(name = "yield", value = "金融商品参数，产品收益率/价格", required = false)
    private String yield;
    
    /**
     * 商品类型，默认为普通商品：normal：普通商品，finance：金融商品
     */
    @ApiModelProperty(name = "productType", value = "商品类型，默认为普通商品：normal：普通商品，finance：金融商品", required = false)
    private String productType;
    
    /**
     * 商品上下架状态：1：上架，2：下架
     */
    @ApiModelProperty(name = "status", value = "商品上下架状态：1：上架，2：下架", required = true)
    @NotNull(message = "属性status不能为空")
    private Integer status;
}