/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.channel.impl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.live.v1.config.LiveGlobalConfig;
import net.polyv.live.v1.constant.LiveURL;
import net.polyv.live.v1.entity.channel.operate.LiveBatchUpdateBarrageRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAdvertListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAdvertListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAuthTokenRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelAuthTokenResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelBasicInfoRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelBasicInfoResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelCallbackSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelCallbackSettingResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelCaptureRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelDetailRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelGetRecordSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelGetRecordSettingResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInfoRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInfoResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInitRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelInitResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelPasswordSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelRecordSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelTransmitListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelTransmitListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelPPTRecordRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateChannelTokenRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateDiskVideosStreamRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelResponse;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelTokenRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteChannelListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteDiskVideosStreamRequest;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteSonChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveGetEnrollListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveGetEnrollListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveListChannelPPTRecordRequest;
import net.polyv.live.v1.entity.channel.operate.LiveListChannelPPTRecordResponse;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoRequest;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoResponse;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateChannelCallbackSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateChannelMaxViewerRequest;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateChannelStreamRequest;
import net.polyv.live.v1.entity.channel.operate.LiveUpdateSonChannelInfoRequest;
import net.polyv.live.v1.service.LiveBaseService;
import net.polyv.live.v1.service.channel.ILiveChannelOperateService;
import net.polyv.live.v1.util.LiveSignUtil;
import net.polyv.live.v2.entity.channel.operate.LiveChannelV2Request;
import net.polyv.live.v2.entity.channel.operate.LiveChannelV2Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveChannelOperateServiceImpl
extends LiveBaseService
implements ILiveChannelOperateService {
    private static final Logger log = LoggerFactory.getLogger(LiveChannelOperateServiceImpl.class);

    @Override
    public LiveChannelResponse createChannel(LiveChannelRequest liveChannelRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = "api.polyv.net/live/v2/channels/";
        LiveChannelResponse liveChannelResponse = this.postFormBodyReturnOne(url, liveChannelRequest, LiveChannelResponse.class);
        return liveChannelResponse;
    }

    @Override
    public LiveChannelV2Response createChannelV2(LiveChannelV2Request liveChannelV2Request) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v4/channel/create";
        return this.postJsonBodyReturnOne(url, liveChannelV2Request, LiveChannelV2Response.class);
    }

    @Override
    public LiveChannelInitResponse createChannelInit(LiveChannelInitRequest liveChannelInitRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/create";
        if (liveChannelInitRequest != null && liveChannelInitRequest.getBasicSetting() != null && StringUtils.isBlank((String)liveChannelInitRequest.getBasicSetting().getOnlyOneLiveEnabled())) {
            liveChannelInitRequest.getBasicSetting().setOnlyOneLiveEnabled("N");
        }
        LiveChannelInitResponse liveChannelInitResponse = this.postJsonBodyReturnOne(url, liveChannelInitRequest, LiveChannelInitResponse.class);
        return liveChannelInitResponse;
    }

    @Override
    public LiveCreateChannelListResponse createChannelList(LiveCreateChannelListRequest liveCreateChannelListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/batch-create";
        LiveCreateChannelListResponse liveCreateChannelListResponse = this.postJsonBodyReturnOne(url, liveCreateChannelListRequest, LiveCreateChannelListResponse.class);
        return liveCreateChannelListResponse;
    }

    @Override
    public Boolean updateChannelSetting(LiveChannelSettingRequest liveChannelSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/update";
        Map<String, String> signMap = LiveSignUtil.getSignMap(liveChannelSettingRequest);
        signMap.put("channelId", liveChannelSettingRequest.getChannelId() + "");
        this.postJsonBodyReturnOne(url, signMap, liveChannelSettingRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean updateChannelDetail(LiveChannelDetailRequest liveChannelDetailRequest) throws IOException, NoSuchAlgorithmException {
        if ("channelPasswd".equals(liveChannelDetailRequest.getField())) {
            liveChannelDetailRequest.setField("password");
        }
        String url = "api.polyv.net/live/v3/channel/detail/update";
        this.postFormBodyReturnOne(url, liveChannelDetailRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveListChannelPPTRecordResponse listPPTRecord(LiveListChannelPPTRecordRequest liveListChannelPPTRecordRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/pptRecord/list";
        return this.getReturnOne(url, liveListChannelPPTRecordRequest, LiveListChannelPPTRecordResponse.class);
    }

    @Override
    public Boolean updateChannelPassword(LiveChannelPasswordSettingRequest liveChannelPasswordSettingRequest) throws IOException, NoSuchAlgorithmException {
        liveChannelPasswordSettingRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channels/%s/passwdSetting", liveChannelPasswordSettingRequest.getUserId());
        this.postFormBodyReturnOne(url, liveChannelPasswordSettingRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteChannel(LiveDeleteChannelRequest liveDeleteChannelRequest) throws IOException, NoSuchAlgorithmException {
        liveDeleteChannelRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channels/%s/delete", liveDeleteChannelRequest.getChannelId());
        this.postFormBodyReturnOne(url, liveDeleteChannelRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteChannelList(LiveDeleteChannelListRequest liveDeleteChannelListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/batch-delete";
        this.postJsonBodyReturnOne(url, liveDeleteChannelListRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean createChannelToken(LiveCreateChannelTokenRequest liveCreateChannelTokenRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channels/%s/set-token", liveCreateChannelTokenRequest.getChannelId());
        String liveCreateChannelTokenResponse = this.postFormBodyReturnOne(url, liveCreateChannelTokenRequest, String.class);
        String success = "success";
        return success.equals(liveCreateChannelTokenResponse);
    }

    @Override
    public LiveChannelInfoResponse getChannelInfo(LiveChannelInfoRequest liveChannelInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channels/%s/get", liveChannelInfoRequest.getChannelId());
        LiveChannelInfoResponse liveChannelInfoResponse = this.getReturnOne(url, liveChannelInfoRequest, LiveChannelInfoResponse.class);
        return liveChannelInfoResponse;
    }

    @Override
    public LiveChannelBasicInfoResponse getChannelBasicInfo(LiveChannelBasicInfoRequest liveChannelBasicInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/get";
        LiveChannelBasicInfoResponse liveChannelBasicInfoResponse = this.postFormBodyReturnOne(url, liveChannelBasicInfoRequest, LiveChannelBasicInfoResponse.class);
        if (liveChannelBasicInfoResponse.getStartTime() != null && liveChannelBasicInfoResponse.getStartTime().getTime() == 0L) {
            liveChannelBasicInfoResponse.setStartTime(null);
        }
        return liveChannelBasicInfoResponse;
    }

    @Override
    public LiveChannelAuthTokenResponse getChannelAuthToken(LiveChannelAuthTokenRequest liveCreateChannelTokenRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/common/get-chat-token";
        LiveChannelAuthTokenResponse liveChannelAuthTokenResponse = this.postFormBodyReturnOne(url, liveCreateChannelTokenRequest, LiveChannelAuthTokenResponse.class);
        return liveChannelAuthTokenResponse;
    }

    @Override
    public LiveCreateSonChannelResponse createSonChannel(LiveCreateSonChannelRequest liveCreateSonChannelRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelAccount/%s/add", liveCreateSonChannelRequest.getChannelId());
        LiveCreateSonChannelResponse liveCreateSonChannelResponse = this.postFormBodyReturnOne(url, liveCreateSonChannelRequest, LiveCreateSonChannelResponse.class);
        return liveCreateSonChannelResponse;
    }

    @Override
    public Boolean updateSonChannelInfo(LiveUpdateSonChannelInfoRequest liveUpdateSonChannelInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelAccount/%s/update", liveUpdateSonChannelInfoRequest.getChannelId());
        this.postFormBodyReturnOne(url, liveUpdateSonChannelInfoRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean createSonChannelToken(LiveCreateSonChannelTokenRequest liveCreateSonChannelTokenRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channels/%s/set-account-token", liveCreateSonChannelTokenRequest.getAccount());
        this.postFormBodyReturnOne(url, liveCreateSonChannelTokenRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveSonChannelInfoResponse getSonChannelInfo(LiveSonChannelInfoRequest liveSonChannelInfoRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelAccount/%s/account", liveSonChannelInfoRequest.getChannelId());
        LiveSonChannelInfoResponse liveSonChannelInfoResponse = this.getReturnOne(url, liveSonChannelInfoRequest, LiveSonChannelInfoResponse.class);
        return liveSonChannelInfoResponse;
    }

    @Override
    public LiveSonChannelInfoListResponse getSonChannelInfoList(LiveSonChannelInfoListRequest liveSonChannelInfoListRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelAccount/%s/accounts", liveSonChannelInfoListRequest.getChannelId());
        LiveSonChannelInfoResponse[] liveSonChannelInfoResponses = this.getReturnOne(url, liveSonChannelInfoListRequest, LiveSonChannelInfoResponse[].class);
        if (liveSonChannelInfoResponses == null) {
            liveSonChannelInfoResponses = new LiveSonChannelInfoResponse[]{};
        }
        LiveSonChannelInfoListResponse liveSonChannelInfoListResponse = new LiveSonChannelInfoListResponse();
        liveSonChannelInfoListResponse.setSonChannelInfos(Arrays.asList(liveSonChannelInfoResponses));
        return liveSonChannelInfoListResponse;
    }

    @Override
    public Boolean deleteSonChannel(LiveDeleteSonChannelRequest liveDeleteSonChannelRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelAccount/%s/delete", liveDeleteSonChannelRequest.getChannelId());
        this.postFormBodyReturnOne(url, liveDeleteSonChannelRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean createChannelPPTRecordTask(LiveCreateChannelPPTRecordRequest liveCreateChannelPPTRecordRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/pptRecord/addRecordTask";
        this.postFormBodyReturnOne(url, liveCreateChannelPPTRecordRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveChannelCallbackSettingResponse getChannelCallbackSetting(LiveChannelCallbackSettingRequest liveChannelCallbackSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/callback/get-setting";
        return this.getReturnOne(url, liveChannelCallbackSettingRequest, LiveChannelCallbackSettingResponse.class);
    }

    @Override
    public Boolean updateChannelCallbackSetting(LiveUpdateChannelCallbackSettingRequest liveUpdateChannelCallbackSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/callback/update-setting";
        this.postFormBodyReturnOne(url, liveUpdateChannelCallbackSettingRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveCreateSonChannelListResponse createSonChannelList(LiveCreateSonChannelListRequest liveCreateSonChannelListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/account/batch-create";
        Map<String, String> map = LiveSignUtil.getSignMap(liveCreateSonChannelListRequest);
        map.put("channelId", liveCreateSonChannelListRequest.getChannelId());
        List<LiveCreateSonChannelListResponse.SonChannelInfo> sonChannelInfos = this.postJsonBodyReturnList(url, map, liveCreateSonChannelListRequest, JSON.toJSONString(liveCreateSonChannelListRequest.getSonChannels()), LiveCreateSonChannelListResponse.SonChannelInfo.class);
        LiveCreateSonChannelListResponse liveCreateSonChannelListResponse = new LiveCreateSonChannelListResponse();
        liveCreateSonChannelListResponse.setSonChannelInfos(sonChannelInfos);
        return liveCreateSonChannelListResponse;
    }

    @Override
    public LiveChannelTransmitListResponse getChannelTransmitList(LiveChannelTransmitListRequest liveChannelTransmitListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/transmit/get-associations";
        List<LiveChannelTransmitListResponse.ChannelTransmit> channelTransmits = this.getReturnList(url, liveChannelTransmitListRequest, LiveChannelTransmitListResponse.ChannelTransmit.class);
        LiveChannelTransmitListResponse liveChannelTransmitListResponse = new LiveChannelTransmitListResponse();
        liveChannelTransmitListResponse.setChannelTransmits(channelTransmits);
        return liveChannelTransmitListResponse;
    }

    @Override
    public Boolean updateChannelMaxViewer(LiveUpdateChannelMaxViewerRequest liveUpdateChannelMaxViewerRequest) throws IOException, NoSuchAlgorithmException {
        liveUpdateChannelMaxViewerRequest.setUserId(LiveGlobalConfig.getUserId());
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/channelRestrict/%s/set-max-viewer", liveUpdateChannelMaxViewerRequest.getChannelId());
        this.postFormBodyReturnOne(url, liveUpdateChannelMaxViewerRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveChannelAdvertListResponse getChannelAdvertList(LiveChannelAdvertListRequest liveChannelAdvertListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/advert/list";
        List<LiveChannelAdvertListResponse.ChannelAdvert> channelAdverts = this.getReturnList(url, liveChannelAdvertListRequest, LiveChannelAdvertListResponse.ChannelAdvert.class);
        LiveChannelAdvertListResponse liveChannelAdvertListResponse = new LiveChannelAdvertListResponse();
        liveChannelAdvertListResponse.setChannelAdverts(channelAdverts);
        return liveChannelAdvertListResponse;
    }

    @Override
    public String getChannelCapture(LiveChannelCaptureRequest liveChannelCaptureRequest) throws IOException, NoSuchAlgorithmException {
        String url = LiveURL.getRealUrl("api.polyv.net/live/v2/stream/%s/capture", liveChannelCaptureRequest.getChannelId());
        return this.postFormBodyReturnOne(url, liveChannelCaptureRequest, String.class);
    }

    @Override
    public Boolean updateChannelStream(LiveUpdateChannelStreamRequest liveUpdateChannelStreamRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/stream/update";
        this.postFormBodyReturnOne(url, liveUpdateChannelStreamRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean createDiskVideosStream(LiveCreateDiskVideosStreamRequest liveCreateDiskVideosStreamRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/stream/add-disk-videos";
        this.postFormBodyReturnOne(url, liveCreateDiskVideosStreamRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean deleteDiskVideosStream(LiveDeleteDiskVideosStreamRequest liveDeleteDiskVideosStreamRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/stream/delete-disk-videos";
        this.postFormBodyReturnOne(url, liveDeleteDiskVideosStreamRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public Boolean batchUpdateBarrage(LiveBatchUpdateBarrageRequest liveBatchUpdateBarrageRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/basic/batchUpdateDanmu";
        this.postFormBodyReturnOne(url, liveBatchUpdateBarrageRequest, String.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveChannelGetRecordSettingResponse liveChannelGetRecordSetting(LiveChannelGetRecordSettingRequest liveChannelGetRecordSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/pptRecord/get-setting";
        return this.getReturnOne(url, liveChannelGetRecordSettingRequest, LiveChannelGetRecordSettingResponse.class);
    }

    @Override
    public Boolean setChannelRecord(LiveChannelRecordSettingRequest liveChannelRecordSettingRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/pptRecord/setting";
        this.postFormBodyReturnOne(url, liveChannelRecordSettingRequest, Object.class);
        return Boolean.TRUE;
    }

    @Override
    public LiveGetEnrollListResponse getLiveEnrollList(LiveGetEnrollListRequest liveGetEnrollListRequest) throws IOException, NoSuchAlgorithmException {
        String url = "api.polyv.net/live/v3/channel/enroll/list";
        return this.getReturnOne(url, liveGetEnrollListRequest, LiveGetEnrollListResponse.class);
    }
}

