/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.live.v1.service.quick.impl;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import net.polyv.common.v1.constant.Constant;
import net.polyv.common.v1.exception.PloyvSdkException;
import net.polyv.common.v1.util.StringUtils;
import net.polyv.live.v1.constant.LiveConstant;
import net.polyv.live.v1.entity.channel.doc.LiveCreateChannelDocRequest;
import net.polyv.live.v1.entity.channel.doc.LiveCreateChannelDocResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelBasicInfoRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelBasicInfoResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveChannelResponse;
import net.polyv.live.v1.entity.channel.operate.LiveChannelSettingRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveCreateSonChannelListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveDeleteChannelRequest;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoListRequest;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoListResponse;
import net.polyv.live.v1.entity.channel.operate.LiveSonChannelInfoResponse;
import net.polyv.live.v1.entity.chat.LiveSetTeacherDataRequest;
import net.polyv.live.v1.entity.player.LiveSetPlayerImgRequest;
import net.polyv.live.v1.entity.player.LiveSetWarmupVedioRequest;
import net.polyv.live.v1.entity.quick.QuickCreateChannelResponse;
import net.polyv.live.v1.entity.quick.QuickCreatePPTChannelRequest;
import net.polyv.live.v1.entity.quick.QuickCreateVideoChannelRequest;
import net.polyv.live.v1.service.channel.impl.LiveChannelDocServiceImpl;
import net.polyv.live.v1.service.channel.impl.LiveChannelOperateServiceImpl;
import net.polyv.live.v1.service.chat.impl.LiveChatRoomServiceImpl;
import net.polyv.live.v1.service.player.impl.LivePlayerServiceImpl;
import net.polyv.live.v1.service.quick.ILiveChannelQuickCreatorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveChannelQuickCreatorServiceImpl
implements ILiveChannelQuickCreatorService {
    private static final Logger log = LoggerFactory.getLogger(LiveChannelQuickCreatorServiceImpl.class);

    @Override
    public QuickCreateChannelResponse quickCreatePPTSence(QuickCreatePPTChannelRequest quickCreateChannelRequest) throws IOException, NoSuchAlgorithmException {
        return this.quickCreatePPTSence(quickCreateChannelRequest, null);
    }

    @Override
    public QuickCreateChannelResponse quickCreatePPTSence(QuickCreatePPTChannelRequest quickCreateChannelRequest, LiveCreateSonChannelListRequest liveCreateSonChannelListRequest) throws IOException, NoSuchAlgorithmException {
        QuickCreateChannelResponse quickCreateChannelResponse = new QuickCreateChannelResponse();
        String channelId = null;
        try {
            String nickname;
            String warmUpFlv;
            String scene = LiveConstant.SceneType.PPT.getDesc();
            LiveChannelRequest liveChannelRequest = new LiveChannelRequest();
            liveChannelRequest.setName(quickCreateChannelRequest.getName()).setChannelPasswd(quickCreateChannelRequest.getChannelPasswd()).setPureRtcEnabled(quickCreateChannelRequest.getPureRtcEnabled()).setScene(scene);
            LiveChannelResponse liveChannelResponse = new LiveChannelOperateServiceImpl().createChannel(liveChannelRequest);
            if (liveChannelResponse == null) {
                throw new PloyvSdkException(Constant.ERROR_CODE, "\u521b\u5efa\u9891\u9053\u5931\u8d25");
            }
            log.info("\u9891\u9053\u521b\u5efa\u6210\u529f{}", (Object)JSON.toJSONString(liveChannelResponse));
            channelId = liveChannelResponse.getChannelId();
            LiveChannelSettingRequest liveChannelSettingRequest = new LiveChannelSettingRequest();
            String splashImg = quickCreateChannelRequest.getSplashImg();
            LiveChannelSettingRequest.BasicSetting basicSetting = new LiveChannelSettingRequest.BasicSetting().setName(quickCreateChannelRequest.getName()).setChannelPasswd(quickCreateChannelRequest.getChannelPasswd()).setCoverImg(quickCreateChannelRequest.getCoverImg()).setSplashImg(splashImg).setSplashEnabled(StringUtils.isBlank(splashImg) ? LiveConstant.Flag.NO.getFlag() : LiveConstant.Flag.YES.getFlag()).setDesc(quickCreateChannelRequest.getDesc()).setStartTime(quickCreateChannelRequest.getStartTime()).setPublisher(quickCreateChannelRequest.getPublisher()).setLinkMicLimit(quickCreateChannelRequest.getLinkMicLimit());
            liveChannelSettingRequest.setChannelId(channelId).setBasicSetting(basicSetting);
            Boolean liveChannelSettingResponse = new LiveChannelOperateServiceImpl().updateChannelSetting(liveChannelSettingRequest);
            if (!liveChannelSettingResponse.booleanValue()) {
                throw new PloyvSdkException(Constant.ERROR_CODE, "\u4fee\u6539\u9891\u9053\u7684\u76f8\u5173\u8bbe\u7f6e\u5931\u8d25");
            }
            log.info("\u4fee\u6539\u9891\u9053\u76f8\u5173\u8bbe\u7f6e\u6210\u529f");
            String coverImage = quickCreateChannelRequest.getCoverImage();
            if (StringUtils.isNotBlank(coverImage)) {
                LiveSetPlayerImgRequest liveSetChatAdminDataRequest = new LiveSetPlayerImgRequest();
                liveSetChatAdminDataRequest.setChannelId(channelId).setCoverImage(coverImage).setCoverHref(quickCreateChannelRequest.getCoverHref());
                Boolean result = new LivePlayerServiceImpl().setPlayerImg(liveSetChatAdminDataRequest);
                if (result == null || !result.booleanValue()) {
                    throw new PloyvSdkException(Constant.ERROR_CODE, "\u6696\u573a\u56fe\u7247\u8bbe\u7f6e\u5931\u8d25");
                }
            }
            if (StringUtils.isNotBlank(warmUpFlv = quickCreateChannelRequest.getWarmUpFlv())) {
                LiveSetWarmupVedioRequest liveSetWarmupVedioRequest = new LiveSetWarmupVedioRequest();
                liveSetWarmupVedioRequest.setChannelId(channelId).setWarmUpFlv(warmUpFlv);
                Boolean result = new LivePlayerServiceImpl().setPlayerWarmUpVedio(liveSetWarmupVedioRequest);
                if (result == null || !result.booleanValue()) {
                    throw new PloyvSdkException(Constant.ERROR_CODE, "\u6696\u573a\u89c6\u9891\u8bbe\u7f6e\u5931\u8d25");
                }
            }
            if (StringUtils.isNotBlank(nickname = quickCreateChannelRequest.getNickname())) {
                LiveSetTeacherDataRequest liveSetTeacherDataRequest = new LiveSetTeacherDataRequest();
                Boolean result = null;
                liveSetTeacherDataRequest.setChannelId(channelId).setNickname(nickname).setActor(quickCreateChannelRequest.getActor()).setPasswd(quickCreateChannelRequest.getChannelPasswd()).setAvatar(quickCreateChannelRequest.getAvatar());
                result = new LiveChatRoomServiceImpl().setChannelTeacherMsg(liveSetTeacherDataRequest);
                if (result == null || !result.booleanValue()) {
                    throw new PloyvSdkException(Constant.ERROR_CODE, "\u8bbe\u7f6e\u8bb2\u5e08\u4fe1\u606f\u5931\u8d25");
                }
                log.info("\u8bbe\u7f6e\u8bb2\u5e08\u4fe1\u606f\u6210\u529f");
            }
            if (liveCreateSonChannelListRequest != null) {
                this.createSonChannelList(channelId, liveCreateSonChannelListRequest);
            }
            if (quickCreateChannelRequest.getFile() != null) {
                LiveCreateChannelDocRequest liveCreateChannelDocRequest = new LiveCreateChannelDocRequest();
                liveCreateChannelDocRequest.setChannelId(channelId).setType(quickCreateChannelRequest.getType()).setFile(quickCreateChannelRequest.getFile()).setDocName(quickCreateChannelRequest.getDocName()).setCallbackUrl(quickCreateChannelRequest.getCallbackUrl());
                LiveCreateChannelDocResponse liveCreateChannelDocResponse = new LiveChannelDocServiceImpl().createChannelDoc(liveCreateChannelDocRequest);
                if (liveCreateChannelDocResponse == null) {
                    throw new PloyvSdkException(Constant.ERROR_CODE, "\u4e0a\u4f20\u9891\u9053\u6587\u6863\u5931\u8d25");
                }
            }
            LiveChannelBasicInfoResponse liveChannelBasicInfoResponse = this.getLiveChannelBasicInfoResponse(channelId);
            quickCreateChannelResponse.setLiveChannelBasicInfoResponse(liveChannelBasicInfoResponse);
            List<LiveSonChannelInfoResponse> sonChannelInfoList = this.getSonChannelInfoList(channelId);
            quickCreateChannelResponse.setSonChannelInfos(sonChannelInfoList);
        }
        catch (PloyvSdkException e) {
            this.tryDeleteChannel(channelId);
            throw e;
        }
        return quickCreateChannelResponse;
    }

    @Override
    public QuickCreateChannelResponse quickCreateVideoSence(QuickCreateVideoChannelRequest quickCreateVideoChannelRequest) throws IOException, NoSuchAlgorithmException {
        return this.quickCreateVideoSence(quickCreateVideoChannelRequest, null);
    }

    @Override
    public QuickCreateChannelResponse quickCreateVideoSence(QuickCreateVideoChannelRequest quickCreateVideoChannelRequest, LiveCreateSonChannelListRequest liveCreateSonChannelListRequest) throws IOException, NoSuchAlgorithmException {
        QuickCreateChannelResponse quickCreateChannelResponse = new QuickCreateChannelResponse();
        String channelId = null;
        try {
            Boolean result;
            String scene = LiveConstant.SceneType.ALONE.getDesc();
            LiveChannelRequest liveChannelRequest = new LiveChannelRequest();
            liveChannelRequest.setName(quickCreateVideoChannelRequest.getName()).setChannelPasswd(quickCreateVideoChannelRequest.getChannelPasswd()).setPureRtcEnabled(quickCreateVideoChannelRequest.getPureRtcEnabled()).setScene(scene);
            LiveChannelResponse liveChannelResponse = new LiveChannelOperateServiceImpl().createChannel(liveChannelRequest);
            if (liveChannelResponse == null) {
                throw new PloyvSdkException(Constant.ERROR_CODE, "\u521b\u5efa\u9891\u9053\u5931\u8d25");
            }
            log.info("\u9891\u9053\u521b\u5efa\u6210\u529f{}", (Object)JSON.toJSONString(liveChannelResponse));
            channelId = liveChannelResponse.getChannelId();
            LiveChannelSettingRequest liveChannelSettingRequest = new LiveChannelSettingRequest();
            String splashImg = quickCreateVideoChannelRequest.getSplashImg();
            LiveChannelSettingRequest.BasicSetting basicSetting = new LiveChannelSettingRequest.BasicSetting().setName(quickCreateVideoChannelRequest.getName()).setChannelPasswd(quickCreateVideoChannelRequest.getChannelPasswd()).setCoverImg(quickCreateVideoChannelRequest.getCoverImg()).setSplashImg(splashImg).setStartTime(quickCreateVideoChannelRequest.getStartTime()).setSplashEnabled(StringUtils.isBlank(splashImg) ? LiveConstant.Flag.NO.getFlag() : LiveConstant.Flag.YES.getFlag()).setDesc(quickCreateVideoChannelRequest.getDesc()).setPublisher(quickCreateVideoChannelRequest.getPublisher()).setLinkMicLimit(quickCreateVideoChannelRequest.getLinkMicLimit());
            liveChannelSettingRequest.setChannelId(channelId).setBasicSetting(basicSetting);
            Boolean liveChannelSettingResponse = new LiveChannelOperateServiceImpl().updateChannelSetting(liveChannelSettingRequest);
            if (!liveChannelSettingResponse.booleanValue()) {
                throw new PloyvSdkException(Constant.ERROR_CODE, "\u4fee\u6539\u9891\u9053\u7684\u76f8\u5173\u8bbe\u7f6e\u5931\u8d25");
            }
            log.info("\u4fee\u6539\u9891\u9053\u76f8\u5173\u8bbe\u7f6e\u6210\u529f");
            if (liveCreateSonChannelListRequest != null) {
                this.createSonChannelList(channelId, liveCreateSonChannelListRequest);
            }
            if (StringUtils.isNotBlank(quickCreateVideoChannelRequest.getCoverImage())) {
                LiveSetPlayerImgRequest liveSetChatAdminDataRequest = new LiveSetPlayerImgRequest();
                liveSetChatAdminDataRequest.setChannelId(channelId).setCoverImage(quickCreateVideoChannelRequest.getCoverImage()).setCoverHref(quickCreateVideoChannelRequest.getCoverHref());
                result = new LivePlayerServiceImpl().setPlayerImg(liveSetChatAdminDataRequest);
                if (result == null || !result.booleanValue()) {
                    throw new PloyvSdkException(Constant.ERROR_CODE, "\u6696\u573a\u56fe\u7247\u8bbe\u7f6e\u5931\u8d25");
                }
            }
            if (StringUtils.isNotBlank(quickCreateVideoChannelRequest.getWarmUpFlv())) {
                LiveSetWarmupVedioRequest liveSetWarmupVedioRequest = new LiveSetWarmupVedioRequest();
                liveSetWarmupVedioRequest.setChannelId(channelId).setWarmUpFlv(quickCreateVideoChannelRequest.getWarmUpFlv());
                result = new LivePlayerServiceImpl().setPlayerWarmUpVedio(liveSetWarmupVedioRequest);
                if (result == null || !result.booleanValue()) {
                    throw new PloyvSdkException(Constant.ERROR_CODE, "\u6696\u573a\u89c6\u9891\u8bbe\u7f6e\u5931\u8d25");
                }
            }
            if (StringUtils.isNotBlank(quickCreateVideoChannelRequest.getNickname())) {
                LiveSetTeacherDataRequest liveSetTeacherDataRequest = new LiveSetTeacherDataRequest();
                result = null;
                liveSetTeacherDataRequest.setChannelId(channelId).setNickname(quickCreateVideoChannelRequest.getNickname()).setActor(quickCreateVideoChannelRequest.getActor()).setPasswd(quickCreateVideoChannelRequest.getChannelPasswd()).setAvatar(quickCreateVideoChannelRequest.getAvatar());
                result = new LiveChatRoomServiceImpl().setChannelTeacherMsg(liveSetTeacherDataRequest);
                if (result == null || !result.booleanValue()) {
                    throw new PloyvSdkException(Constant.ERROR_CODE, "\u8bbe\u7f6e\u8bb2\u5e08\u4fe1\u606f\u5931\u8d25");
                }
                log.info("\u8bbe\u7f6e\u8bb2\u5e08\u4fe1\u606f\u6210\u529f");
            }
            LiveChannelBasicInfoResponse liveChannelBasicInfoResponse = this.getLiveChannelBasicInfoResponse(channelId);
            quickCreateChannelResponse.setLiveChannelBasicInfoResponse(liveChannelBasicInfoResponse);
            List<LiveSonChannelInfoResponse> sonChannelInfoList = this.getSonChannelInfoList(channelId);
            quickCreateChannelResponse.setSonChannelInfos(sonChannelInfoList);
        }
        catch (PloyvSdkException e) {
            this.tryDeleteChannel(channelId);
            throw e;
        }
        return quickCreateChannelResponse;
    }

    private void tryDeleteChannel(String channelId) {
        try {
            if (StringUtils.isNotBlank(channelId)) {
                log.info("\u6355\u83b7\u521b\u5efa\u9891\u9053\u5f02\u5e38\uff0c\u5373\u5c06\u5220\u9664\u5df2\u521b\u5efa\u9891\u9053");
                LiveDeleteChannelRequest liveDeleteChannelRequest = new LiveDeleteChannelRequest();
                liveDeleteChannelRequest.setChannelId(channelId);
                Boolean deleteChannel = new LiveChannelOperateServiceImpl().deleteChannel(liveDeleteChannelRequest);
                log.info("\u6839\u636e\u5f02\u5e38\u5220\u9664\u9891\u9053\u8fd4\u56de\u503c\u4e3a\uff1a{}", (Object)deleteChannel);
            }
        }
        catch (Exception delException) {
            log.error("\u6839\u636e\u5f02\u5e38\u5220\u9664\u9891\u9053\u5931\u8d25\uff0c\u9891\u9053\u53f7\u4e3a{}", (Object)channelId, (Object)delException);
        }
    }

    private LiveChannelBasicInfoResponse getLiveChannelBasicInfoResponse(String channelId) throws IOException, NoSuchAlgorithmException {
        LiveChannelBasicInfoRequest liveChannelBasicInfoRequest = new LiveChannelBasicInfoRequest();
        liveChannelBasicInfoRequest.setChannelId(channelId);
        LiveChannelBasicInfoResponse liveChannelBasicInfoResponse = new LiveChannelOperateServiceImpl().getChannelBasicInfo(liveChannelBasicInfoRequest);
        if (liveChannelBasicInfoResponse == null) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u67e5\u8be2\u9891\u9053\u57fa\u672c\u4fe1\u606f\u5931\u8d25");
        }
        return liveChannelBasicInfoResponse;
    }

    private List<LiveSonChannelInfoResponse> getSonChannelInfoList(String channelId) throws IOException, NoSuchAlgorithmException {
        LiveSonChannelInfoListRequest liveSonChannelInfoListRequest = new LiveSonChannelInfoListRequest();
        liveSonChannelInfoListRequest.setChannelId(channelId);
        LiveSonChannelInfoListResponse liveSonChannelInfoResponse = new LiveChannelOperateServiceImpl().getSonChannelInfoList(liveSonChannelInfoListRequest);
        if (liveSonChannelInfoResponse == null) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u67e5\u8be2\u5b50\u9891\u9053\u4fe1\u606f\u5931\u8d25");
        }
        return liveSonChannelInfoResponse.getSonChannelInfos();
    }

    private void createSonChannelList(String channelId, LiveCreateSonChannelListRequest liveCreateSonChannelListRequest) throws IOException, NoSuchAlgorithmException {
        liveCreateSonChannelListRequest.setChannelId(channelId);
        LiveCreateSonChannelListResponse liveCreateSonChannelListResponse = new LiveChannelOperateServiceImpl().createSonChannelList(liveCreateSonChannelListRequest);
        if (liveCreateSonChannelListResponse == null) {
            throw new PloyvSdkException(Constant.ERROR_CODE, "\u6279\u91cf\u521b\u5efa\u5b50\u9891\u9053\u5931\u8d25");
        }
    }
}

