package net.polyv.live.v1.entity.chat;

import java.util.Date;
import java.util.List;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.live.v1.entity.LivePageCommonResponse;

/**
 * 查询频道聊天记录响应实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("查询频道聊天记录响应实体")
public class LiveGetMessageListResponse extends LivePageCommonResponse {
    
    /**
     * 查询的结果列表
     */
    @ApiModelProperty(name = "contents", value = "查询的结果列表", required = false)
    private List<LiveGetMessageListResponse.MessageList> contents;
    
    @Data
    @Accessors(chain = true)
    @ApiModel("查询的结果列表")
    public static class MessageList {
        
        /**
         * 聊天消息id
         */
        @ApiModelProperty(name = "id", value = "聊天消息id", required = false)
        private String id;
        
        /**
         * 账号id
         */
        @ApiModelProperty(name = "accountId", value = "账号id", required = false)
        private String accountId;
        
        /**
         * 用户ip
         */
        @ApiModelProperty(name = "clientIP", value = "用户ip", required = false)
        private String clientIP;
        
        /**
         * 聊天内容
         */
        @ApiModelProperty(name = "content", value = "聊天内容", required = false)
        private String content;
        
        /**
         * 事件，具体参考聊天室SDK
         */
        @ApiModelProperty(name = "event", value = "事件，具体参考聊天室SDK", required = false)
        private String event;
        
        /**
         * 图片消息的图片地址
         */
        @ApiModelProperty(name = "image", value = "图片消息的图片地址", required = false)
        private String image;
        
        /**
         * 消息类型 redpaper：红包消息 get_redpaper：领取红包消息 chatImg：图片消息 custom：自定义消息（通过socket发送的自定义消息） reward：打赏消息
         * customerMessage：自定义消息（通过http接口发送的自定义消息） 为空：普通聊天消息
         */
        @ApiModelProperty(name = "msgType", value = "消息类型 redpaper：红包消息 get_redpaper：领取红包消息 chatImg：图片消息 " +
                "custom：自定义消息（通过socket发送的自定义消息） reward：打赏消息 customerMessage：自定义消息（通过http接口发送的自定义消息） 为空：普通聊天消息",
                required = false)
        private String msgType;
        
        /**
         * 引用
         */
        @ApiModelProperty(name = "quote", value = "引用", required = false)
        private String quote;
        
        /**
         * 场次号
         */
        @ApiModelProperty(name = "sessionId", value = "场次号", required = false)
        private String sessionId;
        
        /**
         * 房间号
         */
        @ApiModelProperty(name = "roomId", value = "房间号", required = false)
        private String roomId;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 发送消息时的时间戳
         */
        @ApiModelProperty(name = "time", value = "发送消息时的时间戳", required = false)
//        private Long time;
        @JSONField(format = "yyyy-MM-dd HH:mm:ss")
        private Date time;
        
        /**
         * 用户类型 slice：云课堂学员 teacher：讲师 guest：嘉宾 manager：管理员 assistant：助教 viewer：特邀观众 monitor：场监 attendee：研讨会参与者
         * student：普通直播观众
         */
        @ApiModelProperty(name = "userType", value = "用户类型 slice：云课堂学员 teacher：讲师 guest：嘉宾 manager：管理员 assistant：助教 " +
                "viewer：特邀观众 monitor：场监 attendee：研讨会参与者 student：普通直播观众", required = false)
        private String userType;
        
        /**
         * 审核状态 pass：已审核 censor：审核中 delete：删除
         */
        @ApiModelProperty(name = "sourceType", value = "审核状态 pass：已审核 censor：审核中 delete：删除", required = false)
        private String status;
        
        /**
         * 消息来源 public：群聊 extend：管理员私聊
         */
        @ApiModelProperty(name = "sourceType", value = "消息来源 public：群聊 extend：管理员私聊", required = false)
        private String sourceType;
        
        /**
         * 聊天信息数组
         */
        @ApiModelProperty(name = "user", value = "聊天信息数组 ", required = false)
        private LiveGetMessageListResponse.MessageListUser user;
        
    }
    
    @Data
    @Accessors(chain = true)
    @ApiModel("聊天信息数组")
    public static class MessageListUser {
        
        /**
         * 角色
         */
        @ApiModelProperty(name = "actor", value = "角色", required = false)
        private String actor;
        
        /**
         * 是否禁言
         */
        @ApiModelProperty(name = "banned", value = "是否禁言", required = false)
        private Boolean banned;
        
        /**
         * 频道号
         */
        @ApiModelProperty(name = "channelId", value = "频道号", required = false)
        private String channelId;
        
        /**
         * 用户ip
         */
        @ApiModelProperty(name = "clientIp", value = "用户ip", required = false)
        private String clientIp;
        
        /**
         * 观众昵称
         */
        @ApiModelProperty(name = "nickname", value = "观众昵称", required = false)
        private String nickname;
        
        /**
         * 观众头像
         */
        @ApiModelProperty(name = "pic", value = "观众头像", required = false)
        private String pic;
        
        /**
         * 房间号
         */
        @ApiModelProperty(name = "roomId", value = "房间号", required = false)
        private String roomId;
        
        /**
         * 场次号
         */
        @ApiModelProperty(name = "sessionId", value = "场次号", required = false)
        private String sessionId;
        
        /**
         * socketId
         */
        @ApiModelProperty(name = "uid", value = "socketId", required = false)
        private String uid;
        
        /**
         * 用户唯一标示
         */
        @ApiModelProperty(name = "userId", value = "用户唯一标示", required = false)
        private String userId;
        
        /**
         * 观众来源
         */
        @ApiModelProperty(name = "userSource", value = "观众来源", required = false)
        private String userSource;
        
        /**
         * 用户类型 slice：云课堂学员 teacher：讲师 guest：嘉宾 manager：管理员 assistant：助教 viewer：特邀观众 monitor：场监 attendee：研讨会参与者
         * student：普通直播观众
         */
        @ApiModelProperty(name = "userType", value = "用户类型 slice：云课堂学员 teacher：讲师 guest：嘉宾 manager：管理员 assistant：助教 " +
                "viewer：特邀观众 monitor：场监 attendee：研讨会参与者 student：普通直播观众", required = false)
        private String userType;
        
        /**
         * 用户自定义字段
         */
        @ApiModelProperty(name = "param4", value = "用户自定义字段", required = false)
        private String param4;
        
        /**
         * 用户自定义字段
         */
        @ApiModelProperty(name = "param5", value = "用户自定义字段", required = false)
        private String param5;
    }
}