package net.polyv.live.v1.entity.channel.product;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 修改频道商品库列表顺序请求实体
 * @author: jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("修改频道商品库列表顺序请求实体")
public class LiveSortChannelProductRequest extends LiveCommonRequest {
    
    /**
     * 频道号
     */
    @ApiModelProperty(name = "channelId", value = "频道号", required = true)
    @NotNull(message = "属性channelId不能为空")
    private String channelId;
    
    /**
     * 商品ID
     */
    @ApiModelProperty(name = "productId", value = "商品ID", required = true)
    @NotNull(message = "属性productId不能为空")
    private Integer productId;
    
    /**
     * 商品上下移动操作，10：上移，20：下移
     */
    @ApiModelProperty(name = "type", value = "商品上下移动操作，10：上移，20：下移", required = true)
    @NotNull(message = "属性type不能为空")
    private Integer type;
}
