package net.polyv.live.v1.entity.channel.operate;

import com.alibaba.fastjson.annotation.JSONField;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import net.polyv.common.v1.validator.constraints.NotNull;
import net.polyv.live.v1.entity.LiveCommonRequest;

/**
 * 批量修改频道弹幕开关请求实体
 * @author jiangyifan
 */
@Data
@EqualsAndHashCode(callSuper = true)
@Accessors(chain = true)
@ApiModel("批量修改频道弹幕开关请求实体")
public class LiveBatchUpdateBarrageRequest extends LiveCommonRequest {
    /**
     * 是否关闭弹幕功能 Y：表示关闭 N：表示开启
     */
    @ApiModelProperty(name = "closeBarrage", value = "是否关闭弹幕功能 Y：表示关闭 N：表示开启", required = true)
    @NotNull(message = "属性closeBarrage不能为空")
    @JSONField(name = "closeDanmu")
    private String closeBarrage;
    
    /**
     * 是否显示弹幕信息开关， Y：表示显示 N：表示不显示
     */
    @ApiModelProperty(name = "showBarrageInfoEnabled", value = "是否显示弹幕信息开关， Y：表示显示 N：表示不显示", required = true)
    @NotNull(message = "属性showBarrageInfoEnabled不能为空")
    @JSONField(name = "showDanmuInfoEnabled")
    private String showBarrageInfoEnabled;
    
    /**
     * 需要修改弹幕开关的频道号，多个频道号用半角逗号 , 隔开
     */
    @ApiModelProperty(name = "channelIds", value = "需要修改弹幕开关的频道号，多个频道号用半角逗号 , 隔开", required = true)
    @NotNull(message = "属性channelIds不能为空")
    private String channelIds;
    
}
