/*
 * Decompiled with CFR 0.152.
 */
package net.polyv.common.v1.util;

import com.alibaba.fastjson.JSON;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import net.polyv.common.v1.entity.AccountInfo;
import net.polyv.common.v1.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtil {
    private static final Logger log = LoggerFactory.getLogger(FileUtil.class);

    private FileUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFile(String path) throws IOException {
        InputStream in = null;
        File file = new File(path);
        Long filelength = file.length();
        byte[] filecontent = new byte[filelength.intValue()];
        try {
            in = Files.newInputStream(file.toPath(), new OpenOption[0]);
            int readNum = in.read(filecontent);
            String string = new String(filecontent, StandardCharsets.UTF_8);
            return string;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static AccountInfo readConfigFromFile(String path) {
        if (StringUtils.isBlank(path)) {
            path = "/data/password/password.txt";
        }
        String accountInfo = null;
        try {
            accountInfo = FileUtil.readFile(path);
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u6587\u4ef6\u9519\u8bef\uff0c\u6587\u4ef6\u8def\u5f84 {}", (Object)path, (Object)e);
            return null;
        }
        if (StringUtils.isNotBlank(accountInfo)) {
            return JSON.parseObject(accountInfo, AccountInfo.class);
        }
        log.error("\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u6587\u4ef6\u8def\u5f84 {}", (Object)path);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeFile(byte[] bytes, String path) throws IOException {
        try (OutputStream os = null;){
            boolean newFile;
            File localFile = new File(path);
            if (!localFile.exists() && !(newFile = localFile.createNewFile())) {
                throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38\uff0c\u8def\u5f84\uff1a" + path);
            }
            os = Files.newOutputStream(localFile.toPath(), new OpenOption[0]);
            os.write(bytes);
        }
    }
}

